/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.scalars;

import java.io.Serializable;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.scalars.Duration;

public final class Speed
implements Serializable {
    public static final String MILES_PER_HOUR = "mph";
    public static final String KILOMETERS_PER_HOUR = "kph";
    public static final String NAUTICAL_MILES_PER_HOUR = "knots";
    private static final long serialVersionUID = 3268649594426387264L;
    private final Distance distance;
    private final Duration duration;

    public static Speed distancePerDuration(Distance distance, Duration duration) {
        return new Speed(distance, duration);
    }

    public static Speed kilometersPerHour(double kph) {
        return new Speed(Distance.kilometers(kph), Duration.ONE_HOUR);
    }

    public static Speed knots(double knots) {
        return new Speed(Distance.nauticalMiles(knots), Duration.ONE_HOUR);
    }

    public static Speed metersPerSecond(double mps) {
        return new Speed(Distance.meters(mps), Duration.ONE_SECOND);
    }

    public static Speed milesPerHour(double mph) {
        return new Speed(Distance.miles(mph), Duration.ONE_HOUR);
    }

    private Speed(Distance distance, Duration duration) {
        this.distance = distance;
        this.duration = duration;
    }

    public Speed add(Speed that) {
        return Speed.kilometersPerHour(this.asKilometersPerHour() + that.asKilometersPerHour());
    }

    public Duration asDuration(Distance distance) {
        return Duration.seconds(distance.asMeters() / this.asMetersPerSecond());
    }

    public double asKilometersPerHour() {
        return this.distance.asKilometers() / this.duration.asHours();
    }

    public double asKnots() {
        return this.distance.asNauticalMiles() / this.duration.asHours();
    }

    public double asMetersPerSecond() {
        return this.distance.asMeters() / this.duration.asSeconds();
    }

    public double asMilesPerHour() {
        return this.distance.asMiles() / this.duration.asHours();
    }

    public Speed difference(Speed that) {
        return Speed.kilometersPerHour(Math.abs(this.asKilometersPerHour() - that.asKilometersPerHour()));
    }

    public boolean equals(Object object) {
        if (object instanceof Speed) {
            Speed that = (Speed)object;
            return this.asKilometersPerHour() == that.asKilometersPerHour();
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.asKilometersPerHour());
    }

    public boolean isFasterThan(Speed that) {
        return this.asKilometersPerHour() > that.asKilometersPerHour();
    }

    public boolean isFasterThanOrEqualTo(Speed that) {
        return this.asKilometersPerHour() >= that.asKilometersPerHour();
    }

    public boolean isSlowerThan(Speed that) {
        return this.asKilometersPerHour() < that.asKilometersPerHour();
    }

    public boolean isSlowerThanOrEqualTo(Speed that) {
        return this.asKilometersPerHour() <= that.asKilometersPerHour();
    }

    public Speed subtract(Speed that) {
        double delta = this.asKilometersPerHour() - that.asKilometersPerHour();
        return Speed.kilometersPerHour(Math.max(delta, 0.0));
    }

    public String toString() {
        return String.format("%.1f kph (%.1f mph)", this.asKilometersPerHour(), this.asMilesPerHour());
    }
}

