/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.scalars;

import java.io.Serializable;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.scalars.Ratio;

public final class Distance
implements Serializable {
    private static final long serialVersionUID = 3728783948477892064L;
    public static final String FEET_NOTATION = "'";
    public static final String INCHES_NOTATION = "\"";
    protected static final long INCHES_PER_FOOT = 12L;
    protected static final long FEET_PER_MILE = 5280L;
    protected static final double METERS_PER_FOOT = 0.3048;
    protected static final double METERS_PER_KILOMETER = 1000.0;
    protected static final long MILLIMETERS_PER_METER = 1000L;
    protected static final long METERS_PER_NAUTICAL_MILE = 1852L;
    public static final Distance AVERAGE_EARTH_RADIUS = Distance.kilometers(6371.0);
    public static final Distance ZERO = Distance.millimeters(0.0);
    public static final Distance TEN_MILES = Distance.miles(10.0);
    public static final Distance FIFTEEN_HUNDRED_FEET = Distance.feet(1500.0);
    public static final Distance ONE_METER = Distance.meters(1.0);
    public static final Distance MAXIMUM = Distance.millimeters(9.223372036854776E18);
    public static final Distance SEA_TERRITORY_ZONE = Distance.nauticalMiles(12.0);
    private static final int DISTANCE_PRINTING_METERS_THRESHOLD = 1000;
    private final double millimeters;

    public static Distance feet(double feet) {
        return Distance.meters(feet * 0.3048);
    }

    public static Distance feetAndInches(double feet, double inches) {
        return Distance.feet(feet).add(Distance.inches(inches));
    }

    public static Distance inches(double inches) {
        return Distance.feet(inches / 12.0);
    }

    public static Distance kilometers(double kilometers) {
        return Distance.meters(kilometers * 1000.0);
    }

    public static Distance meters(double meters) {
        return Distance.millimeters(meters * 1000.0);
    }

    public static Distance miles(double miles) {
        return Distance.feet(miles * 5280.0);
    }

    public static Distance millimeters(double millimeters) {
        return new Distance(millimeters);
    }

    public static Distance nauticalMiles(double nauticalMiles) {
        return Distance.meters(nauticalMiles * 1852.0);
    }

    private Distance(double millimeters) {
        if (millimeters < 0.0) {
            throw new CoreException("Cannot have a negative distance.");
        }
        this.millimeters = millimeters;
    }

    public Distance add(Distance that) {
        return Distance.millimeters(this.asMillimeters() + that.asMillimeters());
    }

    public double asFeet() {
        return this.asMeters() / 0.3048;
    }

    public double asKilometers() {
        return this.asMeters() / 1000.0;
    }

    public double asMeters() {
        return this.asMillimeters() / 1000.0;
    }

    public double asMiles() {
        return this.asFeet() / 5280.0;
    }

    public double asMillimeters() {
        return this.millimeters;
    }

    public double asNauticalMiles() {
        return this.asMeters() / 1852.0;
    }

    public Distance difference(Distance that) {
        return Distance.millimeters(Math.abs(this.asMillimeters() - that.asMillimeters()));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Distance) {
            return this.asMillimeters() == ((Distance)obj).asMillimeters();
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.millimeters);
    }

    public boolean isGreaterThan(Distance that) {
        return this.asMillimeters() > that.asMillimeters();
    }

    public boolean isGreaterThanOrEqualTo(Distance that) {
        return this.asMillimeters() >= that.asMillimeters();
    }

    public boolean isLessThan(Distance that) {
        return this.asMillimeters() < that.asMillimeters();
    }

    public boolean isLessThanOrEqualTo(Distance that) {
        return this.asMillimeters() <= that.asMillimeters();
    }

    public Distance scaleBy(double multiplier) {
        if (multiplier < 0.0) {
            throw new IllegalArgumentException("Cannot scale a distance by a negative multiplier: " + multiplier);
        }
        return Distance.millimeters(Math.round(this.asMillimeters() * multiplier));
    }

    public Distance scaleBy(Ratio ratio) {
        return this.scaleBy(ratio.asRatio());
    }

    public Distance substract(Distance that) {
        double delta = this.asMillimeters() - that.asMillimeters();
        return Distance.millimeters(Math.max(delta, 0.0));
    }

    public String toString() {
        if (this.asMeters() < 1000.0) {
            return String.format("%.1f meters (%.1f feet)", this.asMeters(), this.asFeet());
        }
        return String.format("%.1f km (%.1f miles)", this.asKilometers(), this.asMiles());
    }

    public static enum UnitAbbreviations {
        M,
        KM,
        MI,
        NMI;

    }
}

