/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.function.Supplier;
import org.openstreetmap.atlas.utilities.scalars.Duration;

public abstract class PipeBuffer {
    private static final Duration AVOID_DEADLOCK_DELAY = Duration.milliseconds(10L);
    private BlockingQueue<Byte> queue;
    private InputStream input;
    private OutputStream output;
    private boolean outClosed = false;
    private boolean inClosed = false;
    private Supplier<Boolean> outClosedAction = () -> true;
    private Supplier<Boolean> inClosedAction = () -> true;

    public InputStream input() {
        if (this.input != null) {
            throw new IllegalAccessError("Cannot create a new pipe from the same PipeBuffer.There needs to be a new PipeBuffer object created for this.");
        }
        if (this.output == null) {
            this.initialize();
        }
        this.input = new InputStream(){

            @Override
            public void close() {
                PipeBuffer.this.inClosed = true;
                PipeBuffer.this.inClosedAction.get();
            }

            @Override
            public int read() throws IOException {
                Byte result = (Byte)PipeBuffer.this.queue.poll();
                while (result == null && !PipeBuffer.this.outClosed) {
                    AVOID_DEADLOCK_DELAY.sleep();
                    result = (Byte)PipeBuffer.this.queue.poll();
                }
                if (result == null) {
                    return -1;
                }
                return result.byteValue();
            }
        };
        return this.input;
    }

    public OutputStream out() {
        if (this.output != null) {
            throw new IllegalAccessError("Cannot create a new pipe from the same PipeBuffer.There needs to be a new PipeBuffer object created for this.");
        }
        if (this.input == null) {
            this.initialize();
        }
        this.output = new OutputStream(){

            @Override
            public void close() {
                PipeBuffer.this.outClosed = true;
                PipeBuffer.this.outClosedAction.get();
            }

            @Override
            public void write(int byteValue) throws IOException {
                boolean added = this.add(byteValue);
                while (!added && !PipeBuffer.this.inClosed) {
                    AVOID_DEADLOCK_DELAY.sleep();
                    this.add(byteValue);
                }
                if (!added) {
                    throw new IOException("Consuming InputStream has been closed.");
                }
            }

            private boolean add(int byteValue) {
                try {
                    PipeBuffer.this.queue.add((byte)byteValue);
                    return true;
                }
                catch (IllegalStateException e) {
                    return false;
                }
            }
        };
        return this.output;
    }

    public int size() {
        return this.queue.size();
    }

    public PipeBuffer withInClosedAction(Supplier<Boolean> inClosedAction) {
        this.inClosedAction = inClosedAction;
        return this;
    }

    public PipeBuffer withOutClosedAction(Supplier<Boolean> outClosedAction) {
        this.outClosedAction = outClosedAction;
        return this;
    }

    protected abstract BlockingQueue<Byte> createBlockingQueue();

    private void initialize() {
        if (this.queue != null) {
            throw new IllegalAccessError("Cannot create a new pipe from the same PipeBuffer.There needs to be a new PipeBuffer object created for this.");
        }
        this.queue = this.createBlockingQueue();
    }
}

