/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.random;

import java.security.SecureRandom;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.utilities.random.RandomTextGenerator;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class RandomTagsSupplier
implements Supplier<Tuple<String, String>> {
    private final Optional<String> fixedName;
    private final Optional<String[]> fixedValues;
    private final Random random;
    private final RandomTextGenerator textGenerator;

    public static Map<String, String> randomTags(int count) {
        return Stream.generate(new RandomTagsSupplier()).limit(count).collect(Collectors.toMap(Tuple::getFirst, Tuple::getSecond, (first, second) -> first));
    }

    public static Map<String, String> randomTags(int count, String fixedKey, String ... fixedValues) {
        return Stream.generate(new RandomTagsSupplier(fixedKey, fixedValues)).limit(count).collect(Collectors.toMap(Tuple::getFirst, Tuple::getSecond, (first, second) -> first));
    }

    public static Map<String, String> randomTagsExcluding(int count, String keyToExclude) {
        return Stream.generate(new RandomTagsSupplier()).filter(entry -> !((String)entry.getFirst()).equals(keyToExclude)).limit(count).collect(Collectors.toMap(Tuple::getFirst, Tuple::getSecond, (first, second) -> first));
    }

    public RandomTagsSupplier() {
        this(null, null, null);
    }

    public RandomTagsSupplier(String fixedName) {
        this(fixedName, null, null);
    }

    public RandomTagsSupplier(String fixedName, String[] fixedValues) {
        this(fixedName, fixedValues, null);
    }

    public RandomTagsSupplier(String fixedName, String[] fixedValues, Random random) {
        this.fixedName = Optional.ofNullable(fixedName);
        this.fixedValues = Optional.ofNullable(fixedValues);
        this.random = random == null ? new SecureRandom() : random;
        this.textGenerator = new RandomTextGenerator(this.random);
    }

    @Override
    public Tuple<String, String> get() {
        String key = this.fixedName.orElse(this.textGenerator.newWord());
        String value = null;
        if (this.fixedValues.isPresent()) {
            String[] fixedValueTable = this.fixedValues.get();
            value = fixedValueTable[this.random.nextInt(fixedValueTable.length)];
        } else {
            value = this.textGenerator.newWord();
        }
        return new Tuple<String, String>(key, value);
    }
}

