/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.maps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public class MultiMap<K, V>
implements Map<K, List<V>>,
Serializable {
    private static final long serialVersionUID = -8408806495092086637L;
    private final Map<K, List<V>> map = new HashMap<K, List<V>>();

    public void add(K key, V value) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, new ArrayList());
        }
        this.map.get(key).add(value);
    }

    public void addAll(MultiMap<K, V> other) {
        for (K key : other.keySet()) {
            this.put(key, new ArrayList());
            Iterator iterator = other.get(key).iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                this.add(key, value);
            }
        }
    }

    public List<V> allValues() {
        ArrayList<V> result = new ArrayList<V>();
        for (List<V> valueList : this.values()) {
            result.addAll(valueList);
        }
        return result;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof MultiMap) {
            return this.map.equals(((MultiMap)other).map);
        }
        return false;
    }

    @Override
    public List<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> map) {
        this.map.putAll(map);
    }

    @Override
    public void putAll(MultiMap<K, V> map) {
        this.putAll((Map<? extends K, ? extends List<V>>)map.getMap());
    }

    public Map<K, V> reduceByKey(BiFunction<V, V, V> reducer) {
        HashMap result = new HashMap();
        for (K key : this.keySet()) {
            Object values = this.get(key);
            if (values.isEmpty()) continue;
            Object token = null;
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (token == null) {
                    token = value;
                    continue;
                }
                token = reducer.apply(token, value);
            }
            result.put(key, token);
        }
        return result;
    }

    @Override
    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Collection<List<V>> values() {
        return this.map.values();
    }

    private Map<K, List<V>> getMap() {
        return this.map;
    }
}

