/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.maps;

import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoLongToLongMapAdapter;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.LongArray;
import org.openstreetmap.atlas.utilities.maps.LargeMap;

public class LongToLongMap
extends LargeMap<Long, Long>
implements ProtoSerializable {
    private static final long serialVersionUID = -3488197516341341480L;

    public LongToLongMap(long maximumSize) {
        super(maximumSize);
    }

    public LongToLongMap(long maximumSize, int hashSize) {
        super(maximumSize, hashSize);
    }

    public LongToLongMap(String name, long maximumSize) {
        super(name, maximumSize);
    }

    public LongToLongMap(String name, long maximumSize, int hashSize) {
        super(name, maximumSize, hashSize);
    }

    public LongToLongMap(String name, long maximumSize, int hashSize, int keyMemoryBlockSize, int keySubArraySize, int valueMemoryBlockSize, int valueSubArraySize) {
        super(name, maximumSize, hashSize, keyMemoryBlockSize, keySubArraySize, valueMemoryBlockSize, valueSubArraySize);
    }

    private LongToLongMap() {
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoLongToLongMapAdapter();
    }

    @Override
    protected LargeArray<Long> createKeys(int memoryBlockSize, int subArraySize) {
        LongArray result = memoryBlockSize > 0 && subArraySize > 0 ? new LongArray(this.getMaximumSize(), memoryBlockSize, subArraySize) : new LongArray(this.getMaximumSize());
        result.withName(this.getName() + " - Keys");
        return result;
    }

    @Override
    protected LargeArray<Long> createValues(int memoryBlockSize, int subArraySize) {
        LongArray result = memoryBlockSize > 0 && subArraySize > 0 ? new LongArray(this.getMaximumSize(), memoryBlockSize, subArraySize) : new LongArray(this.getMaximumSize());
        result.withName(this.getName() + " - Values");
        return result;
    }
}

