/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.maps;

import org.openstreetmap.atlas.utilities.arrays.IntegerArray;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.maps.LargeMap;

public class IntegerToIntegerMap
extends LargeMap<Integer, Integer> {
    private static final long serialVersionUID = -3202467180188514944L;

    public IntegerToIntegerMap(long maximumSize) {
        super(maximumSize);
    }

    public IntegerToIntegerMap(long maximumSize, int hashSize) {
        super(maximumSize, hashSize);
    }

    public IntegerToIntegerMap(String name, long maximumSize, int hashSize, int keyMemoryBlockSize, int keySubArraySize, int valueMemoryBlockSize, int valueSubArraySize) {
        super(name, maximumSize, hashSize, keyMemoryBlockSize, keySubArraySize, valueMemoryBlockSize, valueSubArraySize);
    }

    @Override
    protected LargeArray<Integer> createKeys(int memoryBlockSize, int subArraySize) {
        IntegerArray result = memoryBlockSize > 0 && subArraySize > 0 ? new IntegerArray(this.getMaximumSize(), memoryBlockSize, subArraySize) : new IntegerArray(this.getMaximumSize());
        result.withName(this.getName() + " - Keys");
        return result;
    }

    @Override
    protected LargeArray<Integer> createValues(int memoryBlockSize, int subArraySize) {
        IntegerArray result = memoryBlockSize > 0 && subArraySize > 0 ? new IntegerArray(this.getMaximumSize(), memoryBlockSize, subArraySize) : new IntegerArray(this.getMaximumSize());
        result.withName(this.getName() + " - Values");
        return result;
    }
}

