/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.identifiers;

import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.utilities.collections.StringList;

public class EntityIdentifierGenerator {
    private static final long HIGHEST_ATLAS_ID = 900000000999999L;
    private static final long LOWEST_ATLAS_ID = -900000000999999L;

    public long generateIdentifier(CompleteEntity<?> entity) {
        if (entity instanceof CompleteEdge) {
            throw new IllegalArgumentException("For CompleteEdge, please use generatePositiveIdentifierForEdge");
        }
        return this.generate(entity, true);
    }

    public long generatePositiveIdentifierForEdge(CompleteEdge edge) {
        return this.generate(edge, false);
    }

    String getBasicPropertyString(CompleteEntity<?> entity) {
        String wkt = entity.toWkt();
        if (wkt == null && !(entity instanceof CompleteRelation)) {
            throw new CoreException("Geometry must be set for entity {}", entity.prettify());
        }
        Map<String, String> tags = entity.getTags();
        if (tags == null) {
            throw new CoreException("Tags must be set for entity {}", entity.prettify());
        }
        SortedSet sortedTags = tags.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toCollection(TreeSet::new));
        String tagString = new StringList(sortedTags).join(",");
        return wkt + ";" + tagString;
    }

    String getTypeSpecificPropertyString(CompleteEntity<?> entity) {
        StringBuilder builder = new StringBuilder();
        builder.append(";");
        switch (entity.getType()) {
            case EDGE: {
                CompleteEdge edge = (CompleteEdge)entity;
                if (edge.start() != null) {
                    builder.append(edge.start().getIdentifier());
                }
                builder.append(";");
                if (edge.end() != null) {
                    builder.append(edge.end().getIdentifier());
                }
                return builder.toString();
            }
            case NODE: {
                CompleteNode node = (CompleteNode)entity;
                if (node.inEdges() != null) {
                    node.inEdges().stream().map(AtlasObject::getIdentifier).forEach(identifier -> builder.append(identifier + ","));
                }
                builder.append(";");
                if (node.outEdges() != null) {
                    node.outEdges().stream().map(AtlasObject::getIdentifier).forEach(identifier -> builder.append(identifier + ","));
                }
                return builder.toString();
            }
            case RELATION: {
                CompleteRelation relation = (CompleteRelation)entity;
                if (relation.members() != null) {
                    RelationBean bean = relation.members().asBean();
                    builder.append("RelationBean[");
                    for (RelationBean.RelationBeanItem beanItem : bean) {
                        builder.append("(");
                        builder.append((Object)beanItem.getType());
                        builder.append(",");
                        builder.append(beanItem.getIdentifier());
                        builder.append(",");
                        builder.append(beanItem.getRole());
                        builder.append(")");
                    }
                    builder.append("]");
                }
                return builder.toString();
            }
        }
        return "";
    }

    private long generate(CompleteEntity<?> entity, boolean allowNegativeIdentifiers) {
        int iterations = 0;
        int maximumIterations = 1000;
        String entityString = this.getBasicPropertyString(entity) + this.getTypeSpecificPropertyString(entity);
        UUID entityHash = UUID.nameUUIDFromBytes(entityString.getBytes());
        long shortHash = entityHash.getMostSignificantBits();
        while (!this.isHashSafeToUse(shortHash) || shortHash < 0L && !allowNegativeIdentifiers) {
            entityHash = UUID.nameUUIDFromBytes(entityHash.toString().getBytes());
            shortHash = entityHash.getMostSignificantBits();
            if (iterations > 1000) {
                throw new CoreException("Exceeded maximum iterations ({}) when attempting to generate hash", 1000);
            }
            ++iterations;
        }
        return shortHash;
    }

    private boolean isHashSafeToUse(long hash) {
        return hash >= 900000000999999L || hash < -900000000999999L;
    }
}

