/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.filters;

import java.io.Serializable;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;

public interface IntersectionPolicy
extends Serializable {
    public static final IntersectionPolicy DEFAULT_INTERSECTION_POLICY = new IntersectionPolicy(){
        private static final long serialVersionUID = -7852178753369272322L;

        @Override
        public boolean geometricSurfaceEntityIntersecting(GeometricSurface geometricSurface, AtlasEntity entity) {
            return entity.intersects(geometricSurface);
        }

        @Override
        public boolean multiPolygonEntityIntersecting(MultiPolygon multiPolygon, AtlasEntity entity) {
            if (entity instanceof LineItem) {
                return multiPolygon.overlaps(((LineItem)entity).asPolyLine());
            }
            if (entity instanceof LocationItem) {
                return multiPolygon.fullyGeometricallyEncloses(((LocationItem)entity).getLocation());
            }
            if (entity instanceof Area) {
                return multiPolygon.overlaps(((Area)entity).asPolygon());
            }
            if (entity instanceof Relation) {
                return ((Relation)entity).members().stream().map(RelationMember::getEntity).anyMatch(relationEntity -> this.multiPolygonEntityIntersecting(multiPolygon, (AtlasEntity)relationEntity));
            }
            return false;
        }

        @Override
        public boolean polygonEntityIntersecting(Polygon polygon, AtlasEntity entity) {
            return entity.intersects(polygon);
        }
    };

    default public boolean geometricSurfaceEntityIntersecting(GeometricSurface geometricSurface, AtlasEntity entity) {
        return false;
    }

    default public boolean multiPolygonEntityIntersecting(MultiPolygon multiPolygon, AtlasEntity entity) {
        return false;
    }

    default public boolean polygonEntityIntersecting(Polygon polygon, AtlasEntity entity) {
        return false;
    }
}

