/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.conversion;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public class StringToPredicateConverter<T>
implements Converter<String, Predicate<T>> {
    private final List<String> additionalWhitelistPackages = new ArrayList<String>();

    @Override
    public Predicate<T> convert(String string) {
        Predicate<Object> predicate;
        SecureASTCustomizer securityCustomizer = new SecureASTCustomizer();
        ArrayList<String> importsWhitelist = new ArrayList<String>(Arrays.asList("java.lang", "groovy.lang", "java.util.function"));
        importsWhitelist.addAll(this.additionalWhitelistPackages);
        securityCustomizer.setStarImportsWhitelist(importsWhitelist);
        securityCustomizer.setPackageAllowed(false);
        securityCustomizer.setMethodDefinitionAllowed(false);
        securityCustomizer.setIndirectImportCheckEnabled(true);
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addStarImports(importsWhitelist.toArray(new String[0]));
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.addCompilationCustomizers(securityCustomizer);
        compilerConfiguration.addCompilationCustomizers(importCustomizer);
        GroovyCodeSource groovyCodeSource = new GroovyCodeSource(string, "ThePredicate", "/groovy/shell");
        groovyCodeSource.setCachable(true);
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader(), compilerConfiguration);
        try {
            Class scriptClass = groovyClassLoader.parseClass(groovyCodeSource);
            predicate = element -> {
                try {
                    Binding binding = new Binding();
                    binding.setProperty("e", element);
                    Script script = (Script)scriptClass.getDeclaredConstructor(Binding.class).newInstance(binding);
                    return (Boolean)script.run();
                }
                catch (Exception exception) {
                    throw new CoreException("Something went wrong with this predicate ", exception);
                }
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    groovyClassLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new CoreException("Unable to parse {} into a predicate.", string, exception);
            }
        }
        groovyClassLoader.close();
        return predicate;
    }

    public StringToPredicateConverter<T> withAddedStarImportPackages(List<String> whitelist) {
        this.additionalWhitelistPackages.addAll(whitelist);
        return this;
    }

    public StringToPredicateConverter<T> withAddedStarImportPackages(String ... whitelist) {
        for (String anImport : whitelist) {
            this.additionalWhitelistPackages.add(anImport);
        }
        return this;
    }
}

