/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configurable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;

public class MergedConfiguration
implements Configuration {
    private final List<Configuration> configurations;

    public MergedConfiguration(Configuration ... configurations) {
        this(Arrays.asList(configurations));
    }

    public MergedConfiguration(List<Configuration> configurations) {
        this.configurations = Collections.unmodifiableList(configurations);
    }

    public MergedConfiguration(Resource first, Iterable<Resource> configurations) {
        LinkedList mergedConfigurations = new LinkedList();
        Iterables.stream(Iterables.join(first, configurations)).map(StandardConfiguration::new).forEach(mergedConfigurations::addFirst);
        this.configurations = Collections.unmodifiableList(mergedConfigurations);
    }

    public MergedConfiguration(Resource first, Resource ... configurations) {
        this(first, Iterables.iterable(configurations));
    }

    @Override
    public Set<String> configurationDataKeySet() {
        HashSet<String> keySet = new HashSet<String>();
        this.configurations.forEach(configuration -> keySet.addAll(configuration.configurationDataKeySet()));
        return keySet;
    }

    @Override
    public Configuration configurationForKeyword(String keyword) {
        List<Configuration> configurationsByKeyword = this.configurations.stream().map(configuration -> configuration.configurationForKeyword(keyword)).collect(Collectors.toList());
        return Iterables.equals(this.configurations, configurationsByKeyword) ? this : new MergedConfiguration(configurationsByKeyword);
    }

    @Override
    public Configurable get(String key) {
        return new MergedConfigurable(key, null, Function.identity());
    }

    @Override
    public <R, T> Configurable get(String key, Function<R, T> transform) {
        return new MergedConfigurable<Object, T>(key, null, transform);
    }

    @Override
    public <R, T> Configurable get(String key, R defaultValue, Function<R, T> transform) {
        return new MergedConfigurable<R, T>(key, defaultValue, transform);
    }

    @Override
    public <T> Configurable get(String key, T defaultValue) {
        return new MergedConfigurable(key, defaultValue, Function.identity());
    }

    private class MergedConfigurable<R, T>
    implements Configurable {
        private final R defaultValue;
        private final String key;
        private final Function<R, T> transform;

        MergedConfigurable(String key, R defaultValue, Function<R, T> transform) {
            this.key = key;
            this.transform = transform;
            this.defaultValue = defaultValue;
        }

        @Override
        public <V> V value() {
            HashMap value = MergedConfiguration.this.configurations.stream().map(config -> config.get(this.key)).map(Configurable::value).filter(Objects::nonNull).findFirst().orElse(this.defaultValue);
            if (value instanceof Map) {
                HashMap mergeMap = new HashMap();
                MergedConfiguration.this.configurations.stream().map(config -> config.get(this.key).value()).filter(found -> found instanceof Map).collect(Collectors.toCollection(LinkedList::new)).descendingIterator().forEachRemaining(found -> mergeMap.putAll((Map)found));
                value = mergeMap;
            }
            return (V)this.transform.apply(value);
        }

        @Override
        public <V> Optional<V> valueOption() {
            return Optional.ofNullable(this.value());
        }
    }
}

