/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.subcommands.templates.AtlasLoaderCommand;

public class PackedToTextAtlasCommand
extends AtlasLoaderCommand {
    private static final String SAVED_TO = "saved to ";
    private static final String GEOJSON_OPTION_LONG = "geojson";
    private static final Character GEOJSON_OPTION_SHORT = Character.valueOf('g');
    private static final String GEOJSON_OPTION_DESCRIPTION = "Save atlas as GeoJSON.";
    private static final String LDGEOJSON_OPTION_LONG = "ldgeojson";
    private static final Character LDGEOJSON_OPTION_SHORT = Character.valueOf('l');
    private static final String LDGEOJSON_OPTION_DESCRIPTION = "Save atlas as line-delimited GeoJSON.";
    private static final Integer GEOJSON_CONTEXT = 4;
    private static final Integer LDGEOJSON_CONTEXT = 5;
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new PackedToTextAtlasCommand().runSubcommandAndExit(args);
    }

    @Override
    public String getCommandName() {
        return "packed2text";
    }

    @Override
    public String getSimpleDescription() {
        return "transform a PackedAtlas into a human-readable format";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", PackedToTextAtlasCommand.class.getResourceAsStream("PackedToTextAtlasCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", PackedToTextAtlasCommand.class.getResourceAsStream("PackedToTextAtlasCommandExamplesSection.txt"));
        super.registerManualPageSections();
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerEmptyContext(3);
        this.registerOption(GEOJSON_OPTION_LONG, GEOJSON_OPTION_SHORT, GEOJSON_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, GEOJSON_CONTEXT);
        this.registerOption(LDGEOJSON_OPTION_LONG, LDGEOJSON_OPTION_SHORT, LDGEOJSON_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, LDGEOJSON_CONTEXT);
        super.registerOptionsAndArguments();
    }

    @Override
    protected void processAtlas(Atlas atlas, String atlasFileName, File atlasResource) {
        if (this.optionAndArgumentDelegate.hasVerboseOption()) {
            this.outputDelegate.printlnCommandMessage("converting " + atlasResource.getPath() + "...");
        }
        try {
            this.writeOutput(atlasFileName, atlas);
        }
        catch (Exception exception) {
            this.outputDelegate.printlnErrorMessage("failed to save text file for " + atlasResource.getPath() + ": " + exception.getMessage());
        }
    }

    private void writeOutput(String atlasFileName, Atlas outputAtlas) {
        String fileName = AtlasLoaderCommand.removeSuffixFromFileName(atlasFileName);
        Path concatenatedPath = Paths.get(this.getOutputPath().toAbsolutePath().toString(), fileName);
        File outputFile = null;
        if (this.optionAndArgumentDelegate.getParserContext() == 3) {
            outputFile = new File(concatenatedPath.toAbsolutePath().toString() + FileSuffix.ATLAS + FileSuffix.TEXT);
            outputAtlas.saveAsText(outputFile);
        } else if (this.optionAndArgumentDelegate.getParserContext() == GEOJSON_CONTEXT.intValue()) {
            outputFile = new File(concatenatedPath.toAbsolutePath().toString() + FileSuffix.GEO_JSON);
            outputAtlas.saveAsGeoJson(outputFile);
        } else if (this.optionAndArgumentDelegate.getParserContext() == LDGEOJSON_CONTEXT.intValue()) {
            outputFile = new File(concatenatedPath.toAbsolutePath().toString() + FileSuffix.GEO_JSON);
            outputAtlas.saveAsLineDelimitedGeoJsonFeatures(outputFile, (entity, json) -> {});
        } else {
            throw new AtlasShellToolsException();
        }
        if (this.optionAndArgumentDelegate.hasVerboseOption()) {
            this.outputDelegate.printlnCommandMessage(SAVED_TO + outputFile.getFile().getAbsolutePath());
        }
    }
}

