/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.OutputStreamWritableResource;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.subcommands.templates.MultipleOutputCommand;
import org.openstreetmap.atlas.utilities.testing.TestAtlasHandler;

public class OsmToAtlasCommand
extends MultipleOutputCommand {
    private static final String INPUT_OSM_FILE = "input-osm-file";
    private static final String JOSM = "josm";
    private static final String NAME = "name";
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new OsmToAtlasCommand().runSubcommandAndExit(args);
    }

    @Override
    public int execute() {
        try {
            int code = super.execute();
            if (code != 0) {
                return code;
            }
            Path absoluteOsmPath = this.optionAndArgumentDelegate.getUnaryArgument(INPUT_OSM_FILE).map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow(AtlasShellToolsException::new).toAbsolutePath();
            if (absoluteOsmPath.toFile().isDirectory()) {
                throw new CoreException("{} is a directory", absoluteOsmPath.toString());
            }
            Atlas atlas = TestAtlasHandler.getAtlasFromJsomOsmResource(this.optionAndArgumentDelegate.hasOption(JOSM), new InputStreamResource(() -> new File(absoluteOsmPath.toString()).read()), absoluteOsmPath.getFileName().toString());
            OutputStreamWritableResource outputResource = new OutputStreamWritableResource(this.getOutputFile(absoluteOsmPath).write());
            atlas.save(outputResource);
        }
        catch (Exception exception) {
            this.outputDelegate.printlnErrorMessage("Exception during execution:");
            if (this.optionAndArgumentDelegate.hasVerboseOption()) {
                exception.printStackTrace(System.out);
                System.out.println();
            } else {
                this.outputDelegate.printlnErrorMessage(exception.getMessage());
            }
            return 1;
        }
        return 0;
    }

    @Override
    public String getCommandName() {
        return "osm2atlas";
    }

    public File getOutputFile(Path osmPath) {
        Path outputDirectory = this.getOutputPath();
        String outputFileName = this.optionAndArgumentDelegate.getOptionArgument(NAME).map(nameString -> nameString.replace(FileSuffix.ATLAS.toString(), "")).orElse(osmPath.getFileName().toString().replace(FileSuffix.OSM.toString(), "")).concat(FileSuffix.ATLAS.toString());
        return new File(outputDirectory.toAbsolutePath().toString()).child(outputFileName);
    }

    @Override
    public String getSimpleDescription() {
        return "Convert a .osm file into an Atlas file";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", OsmToAtlasCommand.class.getResourceAsStream("OsmToAtlasCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", OsmToAtlasCommand.class.getResourceAsStream("OsmToAtlasCommandExamplesSection.txt"));
        super.registerManualPageSections();
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerArgument(INPUT_OSM_FILE, ArgumentArity.UNARY, ArgumentOptionality.REQUIRED, new Integer[0]);
        this.registerOptionWithRequiredArgument(NAME, "Name of output atlas file", OptionOptionality.OPTIONAL, "output-name", new Integer[0]);
        this.registerOption(JOSM, "osm file in JOSM format", OptionOptionality.OPTIONAL, new Integer[0]);
        super.registerOptionsAndArguments();
    }
}

