/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.subcommands.templates.AtlasLoaderCommand;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;

public class JavaToProtoSerializationCommand
extends AtlasLoaderCommand {
    private static final String CHECK_OPTION_LONG = "check";
    private static final Character CHECK_OPTION_SHORT = Character.valueOf('c');
    private static final String CHECK_OPTION_DESCRIPTION = "Check the serialization format of the atlas(es) without converting.";
    private static final String REVERSE_OPTION_LONG = "reverse";
    private static final Character REVERSE_OPTION_SHORT = Character.valueOf('R');
    private static final String REVERSE_OPTION_DESCRIPTION = "Convert Protocol Buffers atlas(es) back to Java serialization.";
    private static final Integer CHECK_CONTEXT = 4;
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new JavaToProtoSerializationCommand().runSubcommandAndExit(args);
    }

    @Override
    public String getCommandName() {
        return "java2proto";
    }

    @Override
    public String getSimpleDescription() {
        return "convert Java-serialized atlases to Protocol Buffers format";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", JavaToProtoSerializationCommand.class.getResourceAsStream("JavaToProtoSerializationCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", JavaToProtoSerializationCommand.class.getResourceAsStream("JavaToProtoSerializationCommandExamplesSection.txt"));
        super.registerManualPageSections();
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerOption(REVERSE_OPTION_LONG, REVERSE_OPTION_SHORT, REVERSE_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, new Integer[0]);
        this.registerOption(CHECK_OPTION_LONG, CHECK_OPTION_SHORT, CHECK_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, CHECK_CONTEXT);
        super.registerOptionsAndArguments();
    }

    @Override
    protected void processAtlas(Atlas atlas, String atlasFileName, File atlasResource) {
        PackedAtlas outputAtlas;
        try {
            outputAtlas = (PackedAtlas)atlas;
        }
        catch (ClassCastException exception) {
            outputAtlas = new PackedAtlasCloner().cloneFrom(atlas);
        }
        if (this.optionAndArgumentDelegate.getParserContext() == CHECK_CONTEXT.intValue()) {
            this.outputDelegate.printStdout("atlas ", new TTYAttribute[0]);
            this.outputDelegate.printStdout(atlasResource.getPath(), TTYAttribute.BOLD);
            this.outputDelegate.printStdout(" format: ", new TTYAttribute[0]);
            this.outputDelegate.printlnStdout(outputAtlas.getSerializationFormat().toString(), TTYAttribute.BOLD);
        } else {
            if (this.optionAndArgumentDelegate.hasOption(REVERSE_OPTION_LONG)) {
                outputAtlas.setSaveSerializationFormat(PackedAtlas.AtlasSerializationFormat.JAVA);
            } else {
                outputAtlas.setSaveSerializationFormat(PackedAtlas.AtlasSerializationFormat.PROTOBUF);
            }
            Path concatenatedPath = this.optionAndArgumentDelegate.hasOption("output") ? Paths.get(this.getOutputPath().toAbsolutePath().toString(), atlasFileName) : Paths.get(atlasResource.getAbsolutePath(), new String[0]);
            File outputFile = new File(concatenatedPath.toAbsolutePath().toString());
            outputAtlas.save(outputFile);
            if (this.optionAndArgumentDelegate.hasVerboseOption()) {
                this.outputDelegate.printlnStdout("Saved to " + concatenatedPath.toString(), new TTYAttribute[0]);
            }
        }
    }
}

