/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.locale.IsoCountry;
import org.openstreetmap.atlas.locale.IsoCountryFuzzyMatcher;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;

public class IsoCountryCodeCommand
extends AbstractAtlasShellToolsCommand {
    private static final int DEFAULT_MATCH_NUMBER = 3;
    private static final char NUMBER_OPTION_SHORT = 'n';
    private static final String NUMBER_OPTION_LONG = "number";
    private static final String NUMBER_OPTION_DESCRIPTION = "The number of matches to display. Defaults to 3.";
    private static final String NUMBER_OPTION_HINT = "n";
    private static final char ALL_OPTION_SHORT = 'a';
    private static final String ALL_OPTION_LONG = "all";
    private static final String ALL_OPTION_DESCRIPTION = "Show the entire ISO country listing.";
    private static final Integer ALL_OPTION_CONTEXT = 4;
    private static final String QUERY_HINT = "query";
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new IsoCountryCodeCommand().runSubcommandAndExit(args);
    }

    @Override
    public int execute() {
        if (this.optionAndArgumentDelegate.getParserContext() == ALL_OPTION_CONTEXT.intValue()) {
            return this.allExecute();
        }
        List<String> queries = this.optionAndArgumentDelegate.getVariadicArgument(QUERY_HINT);
        for (int i = 0; i < queries.size(); ++i) {
            String query = queries.get(i);
            Optional<IsoCountry> forIsoCode = IsoCountry.forCountryCode(query);
            Optional<IsoCountry> forDisplayNameExact = IsoCountry.forDisplayCountry(query);
            List<IsoCountry> forDisplayNameTopMatches = IsoCountryFuzzyMatcher.forDisplayCountryTopMatches(this.optionAndArgumentDelegate.getOptionArgument(NUMBER_OPTION_LONG, Integer::parseInt).orElse(3), query);
            if (!forIsoCode.isPresent() && IsoCountry.forCountryCode(query.toUpperCase()).isPresent()) {
                this.outputDelegate.printlnWarnMessage("did you mean case-sensitive ISO code '" + query.toUpperCase() + "'?");
            }
            if (forIsoCode.isPresent()) {
                this.outputDelegate.printlnStdout("ISO code '" + query + "' matched: ", TTYAttribute.BOLD);
                this.printCountry(forIsoCode.get());
            } else if (forDisplayNameExact.isPresent()) {
                this.outputDelegate.printlnStdout("Display country name '" + query + "' matched: ", TTYAttribute.BOLD);
                this.printCountry(forDisplayNameExact.get());
            } else if (!forDisplayNameTopMatches.isEmpty()) {
                this.outputDelegate.printlnStdout("Display country name '" + query + "' had no exact matches. " + forDisplayNameTopMatches.size() + " closest matches are:", TTYAttribute.BOLD);
                for (IsoCountry country : forDisplayNameTopMatches) {
                    this.printCountry(country);
                }
            } else {
                this.outputDelegate.printlnErrorMessage("unmatchable query " + query);
            }
            if (i >= queries.size() - 1) continue;
            this.outputDelegate.printlnStdout("", new TTYAttribute[0]);
        }
        return 0;
    }

    @Override
    public String getCommandName() {
        return "iso-country-code";
    }

    @Override
    public String getSimpleDescription() {
        return "convert ISO country codes to countries and back again";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", IsoCountryCodeCommand.class.getResourceAsStream("IsoCountryCodeCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", IsoCountryCodeCommand.class.getResourceAsStream("IsoCountryCodeCommandExamplesSection.txt"));
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerArgument(QUERY_HINT, ArgumentArity.VARIADIC, ArgumentOptionality.REQUIRED, 3);
        this.registerOptionWithRequiredArgument(NUMBER_OPTION_LONG, Character.valueOf('n'), NUMBER_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, NUMBER_OPTION_HINT, 3);
        this.registerOption(ALL_OPTION_LONG, Character.valueOf('a'), ALL_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, ALL_OPTION_CONTEXT);
        super.registerOptionsAndArguments();
    }

    private int allExecute() {
        ArrayList<String> countries = new ArrayList<String>(IsoCountry.allCountryCodes());
        Collections.sort(countries);
        this.outputDelegate.printlnStdout("Displaying all countries:", TTYAttribute.BOLD);
        for (String country : countries) {
            Optional<IsoCountry> forCode = IsoCountry.forCountryCode(country);
            if (!forCode.isPresent()) {
                throw new AtlasShellToolsException();
            }
            this.printCountry(forCode.get());
        }
        return 0;
    }

    private void printCountry(IsoCountry country) {
        this.outputDelegate.printlnStdout(country.getCountryCode() + "   " + country.getIso3CountryCode() + "   " + country.toString(), TTYAttribute.GREEN);
    }
}

