/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;

public class AtlasShardingConverterCommand
extends AbstractAtlasShellToolsCommand {
    private static final String INPUT = "input";
    private static final String INPUT_DESCRIPTION = "The input folder containing XXX_<old_shard_name>.atlas files";
    private static final String OUTPUT = "output";
    private static final String OUTPUT_DESCRIPTION = "The output folder where XXX_<new_shard_name>.atlas files will be saved";
    private static final String INPUT_SHARDING = "inputSharding";
    private static final String INPUT_SHARDING_DESCRIPTION = "The input sharding";
    private static final String OUTPUT_SHARDING = "outputSharding";
    private static final String OUTPUT_SHARDING_DESCRIPTION = "The output sharding";
    private static final Pattern FILE_MATCHER = Pattern.compile("^[A-Za-z0-9]+_{1}([A-Za-z0-9]|-)+\\.atlas$");
    private static final String EXCEPTION_MESSAGE = "{} needs to be specified.";
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new AtlasShardingConverterCommand().runSubcommandAndExit(args);
    }

    @Override
    public int execute() {
        File inputFolder = new File(this.optionAndArgumentDelegate.getOptionArgument(INPUT).orElseThrow(() -> new CoreException(EXCEPTION_MESSAGE, INPUT)));
        File outputFolder = new File(this.optionAndArgumentDelegate.getOptionArgument(OUTPUT).orElseThrow(() -> new CoreException(EXCEPTION_MESSAGE, OUTPUT)));
        if (!inputFolder.exists()) {
            throw new CoreException("{} does not exist.", inputFolder);
        }
        if (outputFolder.exists()) {
            throw new CoreException("{} already exists.", outputFolder);
        }
        Sharding inputSharding = Sharding.forString(this.optionAndArgumentDelegate.getOptionArgument(INPUT_SHARDING).orElseThrow(() -> new CoreException(EXCEPTION_MESSAGE, INPUT_SHARDING)));
        Sharding outputSharding = Sharding.forString(this.optionAndArgumentDelegate.getOptionArgument(OUTPUT_SHARDING).orElseThrow(() -> new CoreException(EXCEPTION_MESSAGE, OUTPUT_SHARDING)));
        List inputFiles = inputFolder.listFilesRecursively().stream().filter(file -> FILE_MATCHER.matcher(file.getName()).matches()).collect(Collectors.toList());
        this.outputDelegate.printlnCommandMessage("Found input files: " + inputFiles);
        HashMap inputShardToAtlas = new HashMap();
        HashSet countries = new HashSet();
        Set inputShards = inputFiles.stream().map(file -> {
            StringList split = StringList.split(file.getName(), "_");
            String shardName = split.get(1);
            shardName = shardName.substring(0, shardName.indexOf(FileSuffix.ATLAS.toString()));
            Shard inputShard = inputSharding.shardForName(shardName);
            inputShardToAtlas.put(inputShard, file);
            countries.add(split.get(0));
            return inputShard;
        }).collect(Collectors.toSet());
        if (countries.size() > 1) {
            throw new CoreException("Found more than one country in the folder: {}", countries);
        }
        this.outputDelegate.printlnCommandMessage("Found " + inputShards.size() + " input shards: " + inputShards);
        this.outputDelegate.printlnCommandMessage("Found country: " + (String)countries.iterator().next());
        Set outputShards = inputShards.stream().flatMap(inputShard -> Iterables.asList(outputSharding.shards(inputShard.bounds())).stream()).collect(Collectors.toSet());
        if (outputShards.isEmpty()) {
            throw new CoreException("There are no resulting output shards.");
        }
        outputFolder.mkdirs();
        this.outputDelegate.printlnCommandMessage("Found " + outputShards.size() + " output shards: " + outputShards);
        for (Shard outputShard : outputShards) {
            this.outputDelegate.printlnCommandMessage("Processing output shard " + outputShard);
            ArrayList inputAtlases = new ArrayList();
            Iterables.stream(inputSharding.shards(outputShard.bounds())).filter(inputShardToAtlas::containsKey).forEach(inputShard -> inputAtlases.add((File)inputShardToAtlas.get(inputShard)));
            this.outputDelegate.printlnCommandMessage("Loading Atlas with " + inputAtlases);
            Atlas combined = new AtlasResourceLoader().load(inputAtlases);
            Optional<Atlas> result = combined.subAtlas(outputShard.bounds(), AtlasCutType.SOFT_CUT);
            File outputFile = outputFolder.child((String)countries.iterator().next() + "_" + outputShard.getName() + FileSuffix.ATLAS);
            this.outputDelegate.printlnCommandMessage("Saving Atlas to " + outputFile);
            result.ifPresent(atlas -> atlas.save(outputFile));
        }
        return 0;
    }

    @Override
    public String getCommandName() {
        return "sharding-converter";
    }

    @Override
    public String getSimpleDescription() {
        return "Translate Atlas files from one Sharding to another";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", AtlasShardingConverterCommand.class.getResourceAsStream("AtlasShardingConverterCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", AtlasShardingConverterCommand.class.getResourceAsStream("AtlasShardingConverterCommandExamplesSection.txt"));
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerOptionWithRequiredArgument(INPUT, INPUT_DESCRIPTION, OptionOptionality.REQUIRED, "/path/to/atlases", new Integer[0]);
        this.registerOptionWithRequiredArgument(OUTPUT, OUTPUT_DESCRIPTION, OptionOptionality.REQUIRED, "/path/to/output", new Integer[0]);
        this.registerOptionWithRequiredArgument(INPUT_SHARDING, INPUT_SHARDING_DESCRIPTION, OptionOptionality.REQUIRED, "type@parameter", new Integer[0]);
        this.registerOptionWithRequiredArgument(OUTPUT_SHARDING, OUTPUT_SHARDING_DESCRIPTION, OptionOptionality.REQUIRED, "type@parameter", new Integer[0]);
        super.registerOptionsAndArguments();
    }
}

