/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.parsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.OptionArgumentType;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.exceptions.AmbiguousAbbreviationException;
import org.openstreetmap.atlas.utilities.command.parsing.exceptions.ArgumentException;
import org.openstreetmap.atlas.utilities.command.parsing.exceptions.OptionParseException;
import org.openstreetmap.atlas.utilities.command.parsing.exceptions.UnknownOptionException;
import org.openstreetmap.atlas.utilities.command.parsing.exceptions.UnparsableContextException;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleOptionAndArgumentParser {
    public static final String LONG_FORM_PREFIX = "--";
    public static final String SHORT_FORM_PREFIX = "-";
    public static final String OPTION_ARGUMENT_DELIMITER = "=";
    public static final String END_OPTIONS_OPERATOR = "--";
    public static final int NO_CONTEXT = 0;
    private static final String MUST_REGISTER_AT_LEAST_ONE_CONTEXT = "Must register at least one context.";
    private static final String PROVIDED_OPTION_LONG_FORM_WAS_AMBIGUOUS = "provided option long form {} was ambiguous";
    private static final String CANNOT_GET_OPTIONS_BEFORE_PARSING = "Cannot get options before parsing!";
    private static final Logger logger = LoggerFactory.getLogger(SimpleOptionAndArgumentParser.class);
    private final Map<Integer, Set<SimpleOption>> contextToRegisteredOptions = new HashMap<Integer, Set<SimpleOption>>();
    private final Map<Integer, Map<String, ArgumentArity>> contextToArgumentHintToArity = new HashMap<Integer, Map<String, ArgumentArity>>();
    private final Map<Integer, Map<String, ArgumentOptionality>> contextToArgumentHintToOptionality = new HashMap<Integer, Map<String, ArgumentOptionality>>();
    private final Map<Integer, Boolean> contextToRegisteredVariadicArgument = new HashMap<Integer, Boolean>();
    private final Map<Integer, Boolean> contextToRegisteredOptionalArgument = new HashMap<Integer, Boolean>();
    private final SortedSet<Integer> registeredContexts = new TreeSet<Integer>();
    private final Set<String> longFormsSeen = new HashSet<String>();
    private final Set<Character> shortFormsSeen = new HashSet<Character>();
    private final Set<String> argumentHintsSeen = new HashSet<String>();
    private final Map<SimpleOption, Optional<String>> parsedOptions = new LinkedHashMap<SimpleOption, Optional<String>>();
    private final Map<String, List<String>> parsedArguments = new LinkedHashMap<String, List<String>>();
    private int currentContext = 0;
    private boolean parseStepRanAtLeastOnce = false;
    private boolean ignoreUnknownOptions = false;

    public Map<Integer, Map<String, ArgumentArity>> getArgumentHintToArity() {
        return this.contextToArgumentHintToArity;
    }

    public Map<Integer, Map<String, ArgumentOptionality>> getArgumentHintToOptionality() {
        return this.contextToArgumentHintToOptionality;
    }

    public int getContext() {
        return this.currentContext;
    }

    public Map<Integer, Set<SimpleOption>> getContextToRegisteredOptions() {
        return this.contextToRegisteredOptions;
    }

    public Optional<String> getOptionArgument(String longForm) {
        Optional<SimpleOption> option;
        try {
            option = this.getParsedOptionFromLongForm(longForm);
        }
        catch (UnknownOptionException exception) {
            throw new CoreException("{} not a registered option", longForm);
        }
        if (option.isPresent()) {
            return this.parsedOptions.get(option.get());
        }
        return Optional.empty();
    }

    public <T> Optional<T> getOptionArgument(String longForm, StringConverter<T> converter) {
        Optional<String> argument;
        Optional<SimpleOption> option;
        try {
            option = this.getParsedOptionFromLongForm(longForm);
        }
        catch (UnknownOptionException exception) {
            throw new CoreException("{} not a registered option", longForm);
        }
        if (option.isPresent() && (argument = this.parsedOptions.get(option.get())).isPresent()) {
            String argumentValue = argument.get();
            return Optional.ofNullable(converter.convert(argumentValue));
        }
        return Optional.empty();
    }

    public Map<String, SimpleOption> getOptionNameToRegisteredOption() {
        Set<SimpleOption> allOptions = this.getRegisteredOptions();
        HashMap<String, SimpleOption> map = new HashMap<String, SimpleOption>();
        for (SimpleOption option : allOptions) {
            map.put(option.getLongForm(), option);
        }
        return map;
    }

    public SortedSet<Integer> getRegisteredContexts() {
        return this.registeredContexts;
    }

    public Set<SimpleOption> getRegisteredOptions() {
        HashSet<SimpleOption> allOptions = new HashSet<SimpleOption>();
        for (Integer context : this.registeredContexts) {
            allOptions.addAll((Collection<SimpleOption>)this.contextToRegisteredOptions.get(context));
        }
        return allOptions;
    }

    public Optional<String> getUnaryArgument(String hint) {
        if (!this.parseStepRanAtLeastOnce) {
            throw new CoreException("Cannot get arguments before parsing!");
        }
        if (!this.contextToArgumentHintToArity.get(this.currentContext).containsKey(hint)) {
            return Optional.empty();
        }
        if (this.contextToArgumentHintToArity.get(this.currentContext).get(hint) != ArgumentArity.UNARY) {
            throw new CoreException("hint '{}' does not correspond to a unary argument", hint);
        }
        List<String> arguments = this.parsedArguments.get(hint);
        if (arguments != null && arguments.size() == 1) {
            return Optional.of(arguments.get(0));
        }
        logger.debug("No value found for unary argument {}, returning empty Optional", (Object)hint);
        return Optional.empty();
    }

    public List<String> getVariadicArgument(String hint) {
        if (!this.parseStepRanAtLeastOnce) {
            throw new CoreException("Cannot get arguments before parsing!");
        }
        if (!this.contextToArgumentHintToArity.containsKey(this.currentContext) || !this.contextToArgumentHintToArity.get(this.currentContext).containsKey(hint)) {
            throw new CoreException("hint '{}' does not correspond to a registered argument in context {}", hint, this.currentContext);
        }
        if (this.contextToArgumentHintToArity.get(this.currentContext).get(hint) != ArgumentArity.VARIADIC) {
            throw new CoreException("hint '{}' does not correspond to a variadic argument", hint);
        }
        List<String> arguments = this.parsedArguments.get(hint);
        if (arguments != null) {
            return arguments;
        }
        logger.debug("No value found for variadic argument {}, returning empty List", (Object)hint);
        return new ArrayList<String>();
    }

    public boolean hasOption(String longForm) {
        Optional<SimpleOption> option;
        try {
            option = this.getParsedOptionFromLongForm(longForm);
        }
        catch (UnknownOptionException exception) {
            option = Optional.empty();
        }
        return option.isPresent();
    }

    public SimpleOptionAndArgumentParser ignoreUnknownOptions(boolean ignore) {
        this.ignoreUnknownOptions = ignore;
        return this;
    }

    public boolean isEmpty() {
        return this.parsedOptions.isEmpty() && this.parsedArguments.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(List<String> allArguments) throws AmbiguousAbbreviationException, UnknownOptionException, UnparsableContextException {
        this.parsedArguments.clear();
        this.parsedOptions.clear();
        this.currentContext = 0;
        boolean seenEndOptionsOperator = false;
        ArrayList<String> modifiedArguments = new ArrayList<String>();
        for (String argument : allArguments) {
            boolean addBackArg = true;
            if ("--".equals(argument)) {
                if (!seenEndOptionsOperator) {
                    seenEndOptionsOperator = true;
                }
            } else {
                Optional<SimpleOption> option;
                if (SHORT_FORM_PREFIX.equals(argument)) continue;
                if (argument.startsWith("--") && !seenEndOptionsOperator) {
                    String[] split = argument.substring("--".length()).split(OPTION_ARGUMENT_DELIMITER, 2);
                    String optionName = split[0];
                    Optional<SimpleOption> option2 = this.checkForLongOption(optionName, this.getRegisteredOptions(), true);
                    if (!option2.isPresent()) {
                        if (!this.ignoreUnknownOptions) throw new UnknownOptionException(optionName, this.getRegisteredOptions());
                        addBackArg = false;
                    }
                } else if (argument.startsWith(SHORT_FORM_PREFIX) && !seenEndOptionsOperator && !(option = this.checkForShortOption(Character.valueOf(argument.charAt(1)), this.getRegisteredOptions())).isPresent()) {
                    if (!this.ignoreUnknownOptions) throw new UnknownOptionException(Character.valueOf(argument.charAt(1)));
                    addBackArg = false;
                }
            }
            if (!addBackArg) continue;
            modifiedArguments.add(argument);
        }
        TreeSet<String> exceptionMessagesWeSaw = new TreeSet<String>();
        for (Integer context : this.registeredContexts) {
            try {
                this.parseOptionsAndArguments(modifiedArguments, context);
            }
            catch (Exception exception) {
                exceptionMessagesWeSaw.add(String.format("%d: %s (context %d)", context, exception.getMessage(), context));
                continue;
            }
            this.currentContext = context;
            break;
        }
        if (this.currentContext == 0) {
            throw new UnparsableContextException(exceptionMessagesWeSaw);
        }
        this.parseStepRanAtLeastOnce = true;
    }

    public void registerArgument(String argumentHint, ArgumentArity arity, ArgumentOptionality optionality, Integer ... contexts) {
        this.throwIfArgumentHintSeen(argumentHint);
        this.argumentHintsSeen.add(argumentHint);
        if (argumentHint == null || argumentHint.isEmpty()) {
            throw new CoreException("Argument hint cannot be null or empty");
        }
        String[] split = argumentHint.split("\\s+");
        if (split.length > 1) {
            throw new CoreException("Option argument hint cannot contain whitespace");
        }
        if (contexts.length == 0) {
            throw new CoreException("Must provide at least one context.");
        }
        for (int i = 0; i < contexts.length; ++i) {
            this.registerArgumentHelper(contexts[i], argumentHint, arity, optionality);
        }
    }

    public void registerEmptyContext(int context) {
        if (this.registeredContexts.contains(context)) {
            logger.info("Tried to register empty context {}, but {} is already registered", (Object)context, (Object)context);
            return;
        }
        this.registeredContexts.add(context);
        this.contextToRegisteredOptions.put(context, new HashSet());
        this.contextToRegisteredOptionalArgument.put(context, false);
        this.contextToArgumentHintToArity.put(context, new HashMap());
        this.contextToArgumentHintToOptionality.put(context, new HashMap());
        this.contextToRegisteredVariadicArgument.put(context, false);
    }

    public void registerOption(String longForm, Character shortForm, String description, OptionOptionality optionality, Integer ... contexts) {
        if (longForm != null) {
            this.throwIfDuplicateLongForm(longForm);
            this.longFormsSeen.add(longForm);
        }
        if (contexts.length == 0) {
            throw new CoreException(MUST_REGISTER_AT_LEAST_ONE_CONTEXT);
        }
        for (int i = 0; i < contexts.length; ++i) {
            this.registerOptionHelper(contexts[i], longForm, shortForm, description, optionality, OptionArgumentType.NONE, null);
        }
    }

    public void registerOption(String longForm, String description, OptionOptionality optionality, Integer ... contexts) {
        this.registerOption(longForm, null, description, optionality, contexts);
    }

    public void registerOptionWithOptionalArgument(String longForm, Character shortForm, String description, OptionOptionality optionality, String argumentHint, Integer ... contexts) {
        if (longForm != null) {
            this.throwIfDuplicateLongForm(longForm);
            this.longFormsSeen.add(longForm);
        }
        if (shortForm != null) {
            this.throwIfDuplicateShortForm(shortForm);
            this.shortFormsSeen.add(shortForm);
        }
        if (contexts.length == 0) {
            throw new CoreException(MUST_REGISTER_AT_LEAST_ONE_CONTEXT);
        }
        for (int i = 0; i < contexts.length; ++i) {
            this.registerOptionHelper(contexts[i], longForm, shortForm, description, optionality, OptionArgumentType.OPTIONAL, argumentHint);
        }
    }

    public void registerOptionWithOptionalArgument(String longForm, String description, OptionOptionality optionality, String argumentHint, Integer ... contexts) {
        if (longForm != null) {
            this.throwIfDuplicateLongForm(longForm);
            this.longFormsSeen.add(longForm);
        }
        if (contexts.length == 0) {
            throw new CoreException(MUST_REGISTER_AT_LEAST_ONE_CONTEXT);
        }
        for (int i = 0; i < contexts.length; ++i) {
            this.registerOptionHelper(contexts[i], longForm, null, description, optionality, OptionArgumentType.OPTIONAL, argumentHint);
        }
    }

    public void registerOptionWithRequiredArgument(String longForm, Character shortForm, String description, OptionOptionality optionality, String argumentHint, Integer ... contexts) {
        if (longForm != null) {
            this.throwIfDuplicateLongForm(longForm);
            this.longFormsSeen.add(longForm);
        }
        if (shortForm != null) {
            this.throwIfDuplicateShortForm(shortForm);
            this.shortFormsSeen.add(shortForm);
        }
        if (contexts.length == 0) {
            throw new CoreException(MUST_REGISTER_AT_LEAST_ONE_CONTEXT);
        }
        for (int i = 0; i < contexts.length; ++i) {
            this.registerOptionHelper(contexts[i], longForm, shortForm, description, optionality, OptionArgumentType.REQUIRED, argumentHint);
        }
    }

    public void registerOptionWithRequiredArgument(String longForm, String description, OptionOptionality optionality, String argumentHint, Integer ... contexts) {
        if (longForm != null) {
            this.throwIfDuplicateLongForm(longForm);
            this.longFormsSeen.add(longForm);
        }
        if (contexts.length == 0) {
            throw new CoreException(MUST_REGISTER_AT_LEAST_ONE_CONTEXT);
        }
        for (int i = 0; i < contexts.length; ++i) {
            this.registerOptionHelper(contexts[i], longForm, null, description, optionality, OptionArgumentType.REQUIRED, argumentHint);
        }
    }

    private Optional<SimpleOption> checkForLongOption(String longForm, Set<SimpleOption> setToCheck, boolean usePrefixMatching) throws AmbiguousAbbreviationException {
        HashSet<SimpleOption> matchedOptions = new HashSet<SimpleOption>();
        for (SimpleOption option : setToCheck) {
            if (!option.getLongForm().startsWith(longForm)) continue;
            if (option.getLongForm().equals(longForm)) {
                return Optional.of(option);
            }
            if (!usePrefixMatching) continue;
            matchedOptions.add(option);
        }
        if (matchedOptions.size() > 1) {
            List<String> ambiguousOptions = matchedOptions.stream().map(SimpleOption::getLongForm).collect(Collectors.toList());
            throw new AmbiguousAbbreviationException(longForm, new StringList(ambiguousOptions).join(", "));
        }
        if (matchedOptions.size() == 1) {
            SimpleOption matchedOption = matchedOptions.toArray(new SimpleOption[0])[0];
            return Optional.of(matchedOption);
        }
        return Optional.empty();
    }

    private Optional<SimpleOption> checkForShortOption(Character shortForm, Set<SimpleOption> setToCheck) {
        for (SimpleOption option : setToCheck) {
            Optional<Character> optionalForm = option.getShortForm();
            if (!optionalForm.isPresent() || !optionalForm.get().equals(shortForm)) continue;
            return Optional.of(option);
        }
        return Optional.empty();
    }

    private Optional<SimpleOption> getParsedOptionFromLongForm(String longForm) throws UnknownOptionException {
        Optional<SimpleOption> option;
        if (!this.parseStepRanAtLeastOnce) {
            throw new CoreException(CANNOT_GET_OPTIONS_BEFORE_PARSING);
        }
        try {
            if (!this.registeredOptionForLongForm(this.currentContext, longForm).isPresent()) {
                throw new UnknownOptionException(longForm);
            }
            option = this.checkForLongOption(longForm, this.parsedOptions.keySet(), false);
        }
        catch (AmbiguousAbbreviationException exception) {
            throw new CoreException(PROVIDED_OPTION_LONG_FORM_WAS_AMBIGUOUS, longForm);
        }
        return option;
    }

    private boolean parseLongFormOption(int tryContext, String argument, Optional<String> lookahead) throws UnknownOptionException, OptionParseException, AmbiguousAbbreviationException {
        String scrubbedPrefix = argument.substring("--".length());
        String[] split = scrubbedPrefix.split(OPTION_ARGUMENT_DELIMITER, 2);
        String optionName = split[0];
        Optional<SimpleOption> option = this.registeredOptionForLongForm(tryContext, optionName);
        if (option.isPresent()) {
            if (split.length == 1) {
                switch (option.get().getArgumentType()) {
                    case NONE: 
                    case OPTIONAL: {
                        this.parsedOptions.put(option.get(), Optional.empty());
                        return false;
                    }
                    case REQUIRED: {
                        if (lookahead.isPresent()) {
                            this.parsedOptions.put(option.get(), lookahead);
                            return true;
                        }
                        throw new OptionParseException("option '" + option.get().getLongForm() + "' needs an argument");
                    }
                }
                throw new CoreException("Unrecognized OptionArgumentType {}", new Object[]{option.get().getArgumentType()});
            }
            String optionArgument = split[1];
            switch (option.get().getArgumentType()) {
                case NONE: {
                    throw new OptionParseException("option '" + option.get().getLongForm() + "' takes no argument");
                }
                case OPTIONAL: 
                case REQUIRED: {
                    this.parsedOptions.put(option.get(), Optional.ofNullable(optionArgument));
                    return false;
                }
            }
            throw new CoreException("Unrecognized OptionArgumentType {}", new Object[]{option.get().getArgumentType()});
        }
        throw new UnknownOptionException(optionName);
    }

    private void parseOptionsAndArguments(List<String> allArguments, int tryContext) throws UnknownOptionException, OptionParseException, ArgumentException, AmbiguousAbbreviationException {
        ArrayList<String> regularArguments = new ArrayList<String>();
        boolean seenEndOptionsOperator = false;
        this.parsedArguments.clear();
        this.parsedOptions.clear();
        int regularArgumentCounter = 0;
        boolean skipNextArgument = false;
        for (int index = 0; index < allArguments.size(); ++index) {
            boolean consumedLookahead;
            if (skipNextArgument) {
                skipNextArgument = false;
                continue;
            }
            skipNextArgument = false;
            String argument = allArguments.get(index);
            Optional<String> lookahead = Optional.empty();
            if (index + 1 < allArguments.size()) {
                lookahead = Optional.ofNullable(allArguments.get(index + 1));
            }
            if ("--".equals(argument)) {
                if (seenEndOptionsOperator) {
                    regularArguments.add(argument);
                    continue;
                }
                seenEndOptionsOperator = true;
                continue;
            }
            if (SHORT_FORM_PREFIX.equals(argument)) {
                regularArguments.add(argument);
                continue;
            }
            if (argument.startsWith("--") && !seenEndOptionsOperator) {
                consumedLookahead = this.parseLongFormOption(tryContext, argument, lookahead);
                if (!consumedLookahead) continue;
                skipNextArgument = true;
                continue;
            }
            if (argument.startsWith(SHORT_FORM_PREFIX) && !seenEndOptionsOperator) {
                consumedLookahead = this.parseShortFormOption(tryContext, argument, lookahead);
                if (!consumedLookahead) continue;
                skipNextArgument = true;
                continue;
            }
            regularArguments.add(argument);
        }
        Set<SimpleOption> registeredOptions = this.contextToRegisteredOptions.get(tryContext);
        if (registeredOptions != null) {
            for (SimpleOption registeredOption : registeredOptions) {
                if (registeredOption.getOptionality() != OptionOptionality.REQUIRED || this.parsedOptions.keySet().contains(registeredOption)) continue;
                throw new OptionParseException("missing required option " + registeredOption.longForm);
            }
        }
        if (this.contextToRegisteredOptionalArgument.getOrDefault(tryContext, false) != false ? this.contextToArgumentHintToArity.containsKey(tryContext) && regularArguments.size() < this.contextToArgumentHintToArity.get(tryContext).size() - 1 : this.contextToArgumentHintToArity.containsKey(tryContext) && regularArguments.size() < this.contextToArgumentHintToArity.get(tryContext).size()) {
            throw new ArgumentException("missing required argument(s)");
        }
        for (String regularArgument : regularArguments) {
            regularArgumentCounter = this.parseRegularArgument(tryContext, regularArgument, regularArguments.size(), regularArgumentCounter);
        }
        this.parseStepRanAtLeastOnce = true;
    }

    private int parseRegularArgument(int context, String argument, int regularArgumentSize, int regularArgumentCounter) throws ArgumentException {
        int argumentCounter = regularArgumentCounter;
        if (!this.contextToArgumentHintToArity.containsKey(context)) {
            throw new ArgumentException("too many arguments");
        }
        if (this.contextToArgumentHintToArity.containsKey(context) && argumentCounter >= this.contextToArgumentHintToArity.get(context).size()) {
            throw new ArgumentException("too many arguments");
        }
        String argumentHint = (String)this.contextToArgumentHintToArity.get(context).keySet().toArray()[argumentCounter];
        ArgumentArity currentArity = this.contextToArgumentHintToArity.get(context).get(argumentHint);
        switch (currentArity) {
            case UNARY: {
                logger.debug("parsed unary argument hint => {} : value => {}", (Object)argumentHint, (Object)argument);
                this.parsedArguments.put(argumentHint, Arrays.asList(argument));
                ++argumentCounter;
                break;
            }
            case VARIADIC: {
                ArrayList<String> multiArgumentList = this.parsedArguments.get(argumentHint);
                multiArgumentList = multiArgumentList == null ? new ArrayList<String>() : multiArgumentList;
                multiArgumentList.add(argument);
                logger.debug("parsed variadic argument hint => {} : value => {}", (Object)argumentHint, (Object)argument);
                this.parsedArguments.put(argumentHint, multiArgumentList);
                if (argumentCounter == this.contextToArgumentHintToArity.get(context).size() - 1 || multiArgumentList.size() != regularArgumentSize - this.contextToArgumentHintToArity.get(context).size() + 1) break;
                ++argumentCounter;
                break;
            }
            default: {
                throw new CoreException("Unrecognized ArgumentArity {}", new Object[]{currentArity});
            }
        }
        return argumentCounter;
    }

    private boolean parseShortFormOption(int context, String argument, Optional<String> lookahead) throws OptionParseException, UnknownOptionException {
        Optional<SimpleOption> option;
        char optionCharacter;
        int index;
        String scrubbedPrefix = argument.substring(SHORT_FORM_PREFIX.length());
        if (scrubbedPrefix.length() == 1) {
            Optional<SimpleOption> option2 = this.registeredOptionForShortForm(context, Character.valueOf(scrubbedPrefix.charAt(0)));
            if (!option2.isPresent()) {
                throw new UnknownOptionException(Character.valueOf(scrubbedPrefix.charAt(0)));
            }
            switch (option2.get().getArgumentType()) {
                case NONE: 
                case OPTIONAL: {
                    this.parsedOptions.put(option2.get(), Optional.empty());
                    return false;
                }
                case REQUIRED: {
                    if (lookahead.isPresent()) {
                        this.parsedOptions.put(option2.get(), lookahead);
                        return true;
                    }
                    throw new OptionParseException("option '" + option2.get().getShortForm().get() + "' needs an argument");
                }
            }
            throw new CoreException("Bad OptionArgumentType {}", new Object[]{option2.get().getArgumentType()});
        }
        boolean isValidBundle = true;
        for (index = 0; index < scrubbedPrefix.length(); ++index) {
            optionCharacter = scrubbedPrefix.charAt(index);
            option = this.registeredOptionForShortForm(context, Character.valueOf(optionCharacter));
            if (option.isPresent()) {
                if (option.get().getArgumentType() == OptionArgumentType.NONE) continue;
                isValidBundle = false;
                break;
            }
            isValidBundle = false;
            break;
        }
        if (isValidBundle) {
            for (index = 0; index < scrubbedPrefix.length(); ++index) {
                optionCharacter = scrubbedPrefix.charAt(index);
                option = this.registeredOptionForShortForm(context, Character.valueOf(optionCharacter));
                this.parsedOptions.put(option.get(), Optional.empty());
            }
        } else {
            char optionCharacter2 = scrubbedPrefix.charAt(0);
            Optional<SimpleOption> option3 = this.registeredOptionForShortForm(context, Character.valueOf(optionCharacter2));
            if (!option3.isPresent()) {
                throw new UnknownOptionException(Character.valueOf(String.valueOf(optionCharacter2).charAt(0)));
            }
            if (option3.get().getArgumentType() == OptionArgumentType.NONE) {
                throw new OptionParseException("option '" + option3.get().getShortForm().get() + "' takes no argument");
            }
            String optionArgument = scrubbedPrefix.substring(1);
            this.parsedOptions.put(option3.get(), Optional.ofNullable(optionArgument));
        }
        return false;
    }

    private void registerArgumentHelper(int context, String argumentHint, ArgumentArity arity, ArgumentOptionality optionality) {
        if (context < 0) {
            throw new CoreException("Context ID must be a positive integer");
        }
        if (this.contextToRegisteredOptionalArgument.getOrDefault(context, false).booleanValue()) {
            throw new CoreException("Optional argument must be the last registered argument");
        }
        if (arity == ArgumentArity.VARIADIC && this.contextToRegisteredVariadicArgument.getOrDefault(context, false).booleanValue()) {
            throw new CoreException("Cannot register more than one variadic argument");
        }
        if (optionality == ArgumentOptionality.OPTIONAL) {
            if (this.contextToRegisteredOptionalArgument.getOrDefault(context, false).booleanValue()) {
                throw new CoreException("Cannot register more than one optional argument");
            }
            if (this.contextToRegisteredVariadicArgument.getOrDefault(context, false).booleanValue()) {
                throw new CoreException("Cannot register both an optional argument and a variadic argument");
            }
            this.contextToRegisteredOptionalArgument.put(context, true);
        }
        if (arity == ArgumentArity.VARIADIC) {
            this.contextToRegisteredVariadicArgument.put(context, true);
        }
        LinkedHashMap<String, ArgumentArity> argumentHintToArity = this.contextToArgumentHintToArity.get(context) == null ? new LinkedHashMap<String, ArgumentArity>() : this.contextToArgumentHintToArity.get(context);
        argumentHintToArity.put(argumentHint, arity);
        this.contextToArgumentHintToArity.put(context, argumentHintToArity);
        LinkedHashMap<String, ArgumentOptionality> argumentHintToOptionality = this.contextToArgumentHintToOptionality.get(context) == null ? new LinkedHashMap<String, ArgumentOptionality>() : this.contextToArgumentHintToOptionality.get(context);
        argumentHintToOptionality.put(argumentHint, optionality);
        this.contextToArgumentHintToOptionality.put(context, argumentHintToOptionality);
        this.registeredContexts.add(context);
    }

    private void registerOptionHelper(int context, String longForm, Character shortForm, String description, OptionOptionality optionality, OptionArgumentType type, String argumentHint) {
        if (context <= 0) {
            throw new CoreException("Context ID must be a positive integer (>= 1)");
        }
        HashSet<SimpleOption> registeredOptionsForContext = this.contextToRegisteredOptions.get(context) == null ? new HashSet<SimpleOption>() : this.contextToRegisteredOptions.get(context);
        registeredOptionsForContext.add(new SimpleOption(longForm, shortForm, description, optionality, type, argumentHint));
        this.contextToRegisteredOptions.put(context, registeredOptionsForContext);
        this.registeredContexts.add(context);
    }

    private Optional<SimpleOption> registeredOptionForLongForm(int context, String longForm) throws AmbiguousAbbreviationException {
        return this.checkForLongOption(longForm, this.contextToRegisteredOptions.get(context), true);
    }

    private Optional<SimpleOption> registeredOptionForShortForm(int context, Character shortForm) {
        return this.checkForShortOption(shortForm, this.contextToRegisteredOptions.get(context));
    }

    private void throwIfArgumentHintSeen(String hint) {
        if (this.argumentHintsSeen.contains(hint)) {
            throw new CoreException("Cannot register argument hint {} more than once!", hint);
        }
    }

    private void throwIfDuplicateLongForm(String longForm) {
        if (this.longFormsSeen.contains(longForm)) {
            throw new CoreException("Cannot register option {} more than once!", longForm);
        }
    }

    private void throwIfDuplicateShortForm(Character shortForm) {
        if (this.shortFormsSeen.contains(shortForm)) {
            throw new CoreException("Cannot register option {} more than once!", shortForm);
        }
    }

    public class SimpleOption
    implements Comparable<SimpleOption> {
        private final String longForm;
        private final Optional<Character> shortForm;
        private final String description;
        private final OptionOptionality optionality;
        private OptionArgumentType argumentType = OptionArgumentType.NONE;
        private Optional<String> argumentHint = Optional.empty();

        SimpleOption(String longForm, Character shortForm, String description, OptionOptionality optionality, OptionArgumentType argumentType, String argumentHint) {
            if (longForm == null || longForm.isEmpty()) {
                throw new CoreException("Long option form cannot be null or empty");
            }
            if (shortForm != null && !Character.isLetterOrDigit(shortForm.charValue())) {
                throw new CoreException("Invalid short option form {}: must be letter or digit", shortForm);
            }
            if (description == null || description.isEmpty()) {
                throw new CoreException("Description cannot be null or empty");
            }
            this.longForm = longForm;
            this.shortForm = Optional.ofNullable(shortForm);
            this.description = description;
            this.optionality = optionality;
            this.argumentType = argumentType;
            if (this.argumentType != OptionArgumentType.NONE) {
                if (argumentHint != null && !argumentHint.isEmpty()) {
                    String[] split = argumentHint.split("\\s+");
                    if (split.length > 1) {
                        throw new CoreException("Option argument hint cannot contain whitespace");
                    }
                    this.argumentHint = Optional.of(argumentHint);
                } else {
                    throw new CoreException("Option argument hint cannot be null or empty");
                }
            }
        }

        @Override
        public int compareTo(SimpleOption other) {
            String otherCaps = other.longForm.toUpperCase();
            String thisCaps = this.longForm.toUpperCase();
            return thisCaps.compareTo(otherCaps);
        }

        public boolean equals(Object other) {
            if (other instanceof SimpleOption) {
                if (this == other) {
                    return true;
                }
                SimpleOption that = (SimpleOption)other;
                return Objects.equals(this.longForm, that.longForm);
            }
            return false;
        }

        public Optional<String> getArgumentHint() {
            return this.argumentHint;
        }

        public OptionArgumentType getArgumentType() {
            return this.argumentType;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLongForm() {
            return this.longForm;
        }

        public OptionOptionality getOptionality() {
            return this.optionality;
        }

        public Optional<Character> getShortForm() {
            return this.shortForm;
        }

        public int hashCode() {
            int initialPrime = 31;
            int hashSeed = 37;
            return 1147 + Objects.hashCode(this.longForm);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.longForm);
            if (this.shortForm.isPresent()) {
                builder.append(", " + this.shortForm.get());
            }
            return builder.toString();
        }
    }
}

