/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.documentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Optional;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.TemporaryFile;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;

public class PagerHelper {
    private static final String PAGER_ENVIRONMENT_VARIABLE = "ATLAS_SHELL_TOOLS_PAGER";
    private static final String PAGER_FALLBACK_VARIABLE = "PAGER";
    private static final String DEFAULT_PAGER = "less -cSRMis";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageString(String string) {
        String[] pagerFlags;
        Optional<String> pagerProgram;
        String pagerVariable = System.getenv(PAGER_ENVIRONMENT_VARIABLE);
        String pagerFallbackVariable = System.getenv(PAGER_FALLBACK_VARIABLE);
        if (pagerVariable != null && !pagerVariable.isEmpty()) {
            pagerProgram = this.callWhichOnPager(pagerVariable.split("\\s+")[0]);
            pagerFlags = this.extractFlagsFromVariable(pagerVariable);
        } else if (pagerFallbackVariable != null && !pagerFallbackVariable.isEmpty()) {
            pagerProgram = this.callWhichOnPager(pagerFallbackVariable.split("\\s+")[0]);
            pagerFlags = this.extractFlagsFromVariable(pagerFallbackVariable);
        } else {
            pagerProgram = this.callWhichOnPager(DEFAULT_PAGER.split("\\s+")[0]);
            pagerFlags = this.extractFlagsFromVariable(DEFAULT_PAGER);
        }
        TemporaryFile temporaryFile = null;
        try {
            temporaryFile = File.temporary();
        }
        catch (Exception exception) {
            System.out.println(string);
            return;
        }
        if (temporaryFile == null) {
            System.out.println(string);
            return;
        }
        temporaryFile.writeAndClose(string);
        try {
            String[] processBuilderArguments = new String[1 + pagerFlags.length + 1];
            processBuilderArguments[0] = pagerProgram.orElseThrow(AtlasShellToolsException::new);
            if (pagerFlags.length > 0) {
                System.arraycopy(pagerFlags, 0, processBuilderArguments, 1, pagerFlags.length);
            }
            processBuilderArguments[processBuilderArguments.length - 1] = temporaryFile.getAbsolutePath();
            ProcessBuilder processBuilder = new ProcessBuilder(processBuilderArguments);
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            Process process = processBuilder.start();
            process.waitFor();
        }
        catch (Exception exception) {
            System.out.println(string);
        }
        finally {
            temporaryFile.delete();
        }
    }

    private Optional<String> callWhichOnPager(String pager) {
        Process process;
        String whichProgram = "which";
        try {
            process = new ProcessBuilder("which", pager).start();
        }
        catch (IOException exception) {
            return Optional.empty();
        }
        InputStream stream = process.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        try {
            line = reader.readLine();
        }
        catch (IOException exception) {
            return Optional.empty();
        }
        if (line == null || line.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(line);
    }

    private String[] extractFlagsFromVariable(String variable) {
        String[] flags = variable.split("\\s+");
        return Arrays.copyOfRange(flags, 1, flags.length);
    }
}

