/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.documentation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;
import org.openstreetmap.atlas.utilities.command.documentation.DocumentationFormatType;
import org.openstreetmap.atlas.utilities.command.documentation.DocumentationRegistrar;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.OptionArgumentType;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.SimpleOptionAndArgumentParser;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;
import org.openstreetmap.atlas.utilities.command.terminal.TTYStringBuilder;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public final class DocumentationFormatter {
    public static final int DEFAULT_MAXIMUM_COLUMN = 80;
    public static final int DEFAULT_CODE_INDENT_LEVEL = 2;
    public static final int DEFAULT_CODE_INDENT_WIDTH = 4;
    public static final int DEFAULT_PARAGRAPH_INDENT_LEVEL = 1;
    public static final int DEFAULT_INNER_PARAGRAPH_INDENT_LEVEL = 2;
    public static final int DEFAULT_PARAGRAPH_INDENT_WIDTH = 4;

    public static void addCodeLine(int indentationLevel, String string, TTYStringBuilder builder) {
        DocumentationFormatter.addCodeLineAtExactIndentation(indentationLevel * 4, string, builder);
    }

    public static void addCodeLineAtExactIndentation(int exactIndentation, String string, TTYStringBuilder builder) {
        builder.pushExactIndentWidth(exactIndentation).append(string, new TTYAttribute[0]).popIndentation();
    }

    public static void addParagraphWithLineWrapping(int indentationLevel, int maximumColumn, String string, TTYStringBuilder builder, boolean indentFirstLine) {
        DocumentationFormatter.addParagraphWithLineWrappingAtExactIndentation(indentationLevel * 4, maximumColumn, string, builder, indentFirstLine);
    }

    public static void addParagraphWithLineWrappingAtExactIndentation(int exactIndentation, int maximumColumn, String string, TTYStringBuilder builder, boolean indentFirstLine) {
        int lineWidth;
        int spaceLeft = lineWidth = maximumColumn - exactIndentation;
        String[] words = string.split("\\s+");
        boolean firstIteration = true;
        if (indentFirstLine) {
            builder.pushExactIndentWidth(exactIndentation);
        } else {
            builder.pushExactIndentWidth(0);
        }
        for (String word : words) {
            if (word.length() == spaceLeft) {
                builder.append(word, new TTYAttribute[0]).pushExactIndentWidth(0).newline().pushExactIndentWidth(exactIndentation);
                spaceLeft = lineWidth;
            } else if (word.length() + " ".length() > spaceLeft) {
                if (!firstIteration) {
                    builder.newline();
                    builder.pushExactIndentWidth(exactIndentation);
                }
                builder.append(word + " ", new TTYAttribute[0]).pushExactIndentWidth(0);
                spaceLeft = lineWidth - (word.length() + " ".length());
            } else {
                builder.append(word + " ", new TTYAttribute[0]).pushExactIndentWidth(0);
                spaceLeft -= word.length() + " ".length();
            }
            firstIteration = false;
        }
    }

    public static void generateTextForGenericSection(String sectionName, int maximumColumn, TTYStringBuilder builder, DocumentationRegistrar registrar) {
        List<Tuple<DocumentationFormatType, String>> sectionContents = registrar.getSectionContents(sectionName);
        ArrayList<Tuple<DocumentationFormatType, String>> sectionContentsFiltered = new ArrayList<Tuple<DocumentationFormatType, String>>();
        for (Tuple<DocumentationFormatType, String> tuple : sectionContents) {
            if (tuple.getSecond().isEmpty()) continue;
            sectionContentsFiltered.add(tuple);
        }
        builder.clearIndentationStack();
        builder.append(sectionName, TTYAttribute.BOLD).newline();
        for (int index = 0; index < sectionContentsFiltered.size(); ++index) {
            Tuple tuple = (Tuple)sectionContentsFiltered.get(index);
            DocumentationFormatType type = (DocumentationFormatType)((Object)tuple.getFirst());
            String text = (String)tuple.getSecond();
            if (type == DocumentationFormatType.CODE) {
                DocumentationFormatter.addCodeLine(2, text, builder);
                builder.newline();
            } else if (type == DocumentationFormatType.PARAGRAPH) {
                DocumentationFormatter.addParagraphWithLineWrapping(1, maximumColumn, text, builder, true);
                builder.newline();
            }
            if (index >= sectionContentsFiltered.size() - 1) continue;
            builder.newline();
        }
    }

    public static void generateTextForNameSection(String name, String simpleDescription, TTYStringBuilder builder) {
        builder.append("NAME", TTYAttribute.BOLD).newline();
        builder.clearIndentationStack();
        builder.withLevelWidth(4);
        builder.pushIndentLevel(1).append(name + " -- " + simpleDescription, new TTYAttribute[0]).popIndentation();
        builder.newline();
    }

    public static String generateTextForOptionsSection(int maximumColumn, Set<SimpleOptionAndArgumentParser.SimpleOption> options, TTYStringBuilder builder) {
        ArrayList<SimpleOptionAndArgumentParser.SimpleOption> sortedOptions = new ArrayList<SimpleOptionAndArgumentParser.SimpleOption>(options);
        Collections.sort(sortedOptions);
        builder.clearIndentationStack();
        builder.withLevelWidth(4);
        builder.append("OPTIONS", TTYAttribute.BOLD).newline();
        for (int index = 0; index < sortedOptions.size(); ++index) {
            SimpleOptionAndArgumentParser.SimpleOption option = (SimpleOptionAndArgumentParser.SimpleOption)sortedOptions.get(index);
            builder.pushIndentLevel(1).append("--" + option.getLongForm(), TTYAttribute.BOLD).popIndentation();
            OptionArgumentType argumentType = option.getArgumentType();
            if (argumentType == OptionArgumentType.OPTIONAL) {
                builder.append("[=" + option.getArgumentHint().orElseThrow(AtlasShellToolsException::new) + "]", new TTYAttribute[0]);
            } else if (argumentType == OptionArgumentType.REQUIRED) {
                builder.append("=<" + option.getArgumentHint().orElseThrow(AtlasShellToolsException::new) + ">", new TTYAttribute[0]);
            }
            if (option.getShortForm().isPresent()) {
                builder.append(", ", new TTYAttribute[0]);
                builder.append("-" + option.getShortForm().orElseThrow(AtlasShellToolsException::new).toString(), TTYAttribute.BOLD);
                if (argumentType == OptionArgumentType.OPTIONAL) {
                    builder.append("[" + option.getArgumentHint().orElseThrow(AtlasShellToolsException::new) + "]", new TTYAttribute[0]);
                } else if (argumentType == OptionArgumentType.REQUIRED) {
                    builder.append("<" + option.getArgumentHint().orElseThrow(AtlasShellToolsException::new) + ">", new TTYAttribute[0]);
                }
            }
            builder.newline();
            DocumentationFormatter.addParagraphWithLineWrapping(2, maximumColumn, option.getDescription(), builder, true);
            builder.newline();
            if (index >= sortedOptions.size() - 1) continue;
            builder.newline();
        }
        return builder.toString();
    }

    public static void generateTextForSynopsisSection(String programName, int maximumColumn, Map<Integer, Set<SimpleOptionAndArgumentParser.SimpleOption>> optionsWithContext, Set<Integer> contexts, Map<Integer, Map<String, ArgumentArity>> argumentArities, Map<Integer, Map<String, ArgumentOptionality>> argumentOptionalities, TTYStringBuilder builder) {
        builder.append("SYNOPSIS", TTYAttribute.BOLD).newline();
        builder.clearIndentationStack();
        builder.withLevelWidth(4);
        for (Integer context : contexts) {
            builder.pushIndentLevel(1).append(programName, TTYAttribute.UNDERLINE).popIndentation().append(" ", new TTYAttribute[0]);
            StringBuilder paragraph = new StringBuilder();
            ArrayList sortedOptions = new ArrayList(optionsWithContext.getOrDefault(context, new HashSet()));
            Collections.sort(sortedOptions);
            for (SimpleOptionAndArgumentParser.SimpleOption option : sortedOptions) {
                if (option.getOptionality() == OptionOptionality.OPTIONAL) {
                    paragraph.append("[");
                }
                paragraph.append("--" + option.getLongForm());
                OptionArgumentType argumentType = option.getArgumentType();
                if (argumentType == OptionArgumentType.OPTIONAL) {
                    paragraph.append("[=" + option.getArgumentHint().orElseThrow(AtlasShellToolsException::new) + "]");
                } else if (argumentType == OptionArgumentType.REQUIRED) {
                    paragraph.append("=<" + option.getArgumentHint().orElseThrow(AtlasShellToolsException::new) + ">");
                }
                if (option.getOptionality() == OptionOptionality.OPTIONAL) {
                    paragraph.append("]");
                }
                paragraph.append(" ");
            }
            for (String hint : ((Map)argumentArities.getOrDefault(context, new HashMap())).keySet()) {
                if (argumentOptionalities.get(context).get(hint) == ArgumentOptionality.OPTIONAL) {
                    paragraph.append("[");
                } else if (argumentOptionalities.get(context).get(hint) == ArgumentOptionality.REQUIRED) {
                    paragraph.append("<");
                }
                paragraph.append(hint);
                if (argumentArities.get(context).get(hint) == ArgumentArity.VARIADIC) {
                    paragraph.append("...");
                }
                if (argumentOptionalities.get(context).get(hint) == ArgumentOptionality.OPTIONAL) {
                    paragraph.append("] ");
                    continue;
                }
                if (argumentOptionalities.get(context).get(hint) != ArgumentOptionality.REQUIRED) continue;
                paragraph.append("> ");
            }
            int exactIndentation = 4 + programName.length() + " ".length();
            DocumentationFormatter.addParagraphWithLineWrappingAtExactIndentation(exactIndentation, maximumColumn, paragraph.toString(), builder, false);
            builder.pushIndentLevel(0).newline();
        }
    }

    private DocumentationFormatter() {
    }
}

