/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.utilities.collections.FilteredIterable;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class StreamIterable<T>
implements Iterable<T> {
    private final Iterable<T> source;
    private boolean parallel = false;

    protected StreamIterable(Iterable<T> source) {
        this.source = source;
    }

    protected StreamIterable(Iterable<T> source, boolean parallel) {
        this.source = source;
        this.parallel = parallel;
    }

    public boolean allMatch(Predicate<T> predicate) {
        return StreamSupport.stream(this.source.spliterator(), this.parallel).allMatch(predicate);
    }

    public boolean anyMatch(Predicate<T> predicate) {
        return StreamSupport.stream(this.source.spliterator(), this.parallel).anyMatch(predicate);
    }

    public Iterable<T> collect() {
        return this.source;
    }

    public List<T> collectToList() {
        return Iterables.asList(this.source);
    }

    public Set<T> collectToSet() {
        return Iterables.asSet(this.source);
    }

    public SortedSet<T> collectToSortedSet() {
        return Iterables.asSortedSet(this.source);
    }

    public StreamIterable<T> disableParallelization() {
        this.parallel = false;
        return this;
    }

    public StreamIterable<T> enableParallelization() {
        this.parallel = true;
        return this;
    }

    public StreamIterable<T> filter(Predicate<T> filter) {
        return new StreamIterable<T>(Iterables.filter(this.source, filter), this.parallel);
    }

    public <IdentifierType> StreamIterable<T> filter(Set<IdentifierType> filterSet, Function<T, IdentifierType> identifier) {
        return new StreamIterable<T>(new FilteredIterable<T, IdentifierType>(this.source, filterSet, identifier), this.parallel);
    }

    public Optional<T> firstMatching(Predicate<T> filter) {
        return Iterables.firstMatching(this.source, filter);
    }

    public <V> StreamIterable<V> flatMap(Function<T, Iterable<? extends V>> flatMap) {
        return new StreamIterable<V>(Iterables.translateMulti(this.source, flatMap), this.parallel);
    }

    @Override
    public Iterator<T> iterator() {
        return this.source.iterator();
    }

    public Optional<T> lastMatching(Predicate<T> filter) {
        return Iterables.lastMatching(this.source, filter);
    }

    public <V> StreamIterable<V> map(Function<T, V> map) {
        return new StreamIterable<V>(Iterables.translate(this.source, map), this.parallel);
    }

    public StreamIterable<T> truncate(int startIndex, int indexFromEnd) {
        return new StreamIterable<T>(Iterables.truncate(this.source, startIndex, indexFromEnd), this.parallel);
    }
}

