/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.utilities.collections.FilteredIterable;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;
import org.openstreetmap.atlas.utilities.collections.SubIterable;

public final class Iterables {
    public static <T> boolean addAll(Collection<T> addHere, Iterable<T> from) {
        int oldSize = addHere.size();
        StreamSupport.stream(from.spliterator(), false).forEach(addHere::add);
        return oldSize < addHere.size();
    }

    public static <T> Iterable<T> asIterable(Iterable<T> types) {
        return types::iterator;
    }

    public static <T> List<T> asList(Iterable<T> types) {
        if (types instanceof List) {
            return (List)types;
        }
        ArrayList result = new ArrayList();
        types.forEach(result::add);
        return result;
    }

    public static <T> List<T> asList(T[] types) {
        ArrayList<T> result = new ArrayList<T>();
        for (T type : types) {
            result.add(type);
        }
        return result;
    }

    public static <K, V> Map<K, V> asMap(Iterable<Map.Entry<K, V>> types) {
        HashMap result = new HashMap();
        types.forEach(entry -> result.put(entry.getKey(), entry.getValue()));
        return result;
    }

    public static <T> Queue<T> asQueue(Iterable<T> types) {
        LinkedList result = new LinkedList();
        types.forEach(result::add);
        return result;
    }

    public static <T> Set<T> asSet(Iterable<T> types) {
        HashSet result = new HashSet();
        types.forEach(result::add);
        return result;
    }

    public static <T> Set<T> asSet(T[] types) {
        HashSet<T> result = new HashSet<T>();
        for (T type : types) {
            result.add(type);
        }
        return result;
    }

    public static <T> SortedSet<T> asSortedSet(Iterable<T> types) {
        TreeSet result = new TreeSet();
        types.forEach(result::add);
        return result;
    }

    public static <T> boolean contains(Iterable<T> types, T type) {
        if (types instanceof Collection) {
            return ((Collection)types).contains(type);
        }
        for (T candidate : types) {
            if (!candidate.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static <T> long count(Iterable<T> types, ToLongFunction<T> typeCounter) {
        long result = 0L;
        for (T type : types) {
            result += typeCounter.applyAsLong(type);
        }
        return result;
    }

    public static <T> Iterable<T> emptyIterable(T example) {
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }
        };
    }

    public static <T> boolean equals(Iterable<T> that, Iterable<T> other) {
        boolean otherIsNull;
        boolean thatIsNull = that == null;
        boolean bl = otherIsNull = other == null;
        if (thatIsNull || otherIsNull) {
            return thatIsNull && otherIsNull;
        }
        long thatSize = Iterables.size(that);
        if (thatSize != Iterables.size(other)) {
            return false;
        }
        Iterator<T> thatIterator = that.iterator();
        Iterator<T> otherIterator = other.iterator();
        while (thatIterator.hasNext()) {
            if (thatIterator.next().equals(otherIterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> Iterable<T> filter(Iterable<T> input, Predicate<T> matcher) {
        return Iterables.filterTranslate(input, item -> item, matcher);
    }

    public static <T, I> FilteredIterable<T, I> filter(Iterable<T> types, Set<I> filterSet, Function<T, I> identifier) {
        return new FilteredIterable<T, I>(types, filterSet, identifier);
    }

    public static <I, O> Iterable<O> filterTranslate(final Iterable<I> input, final Function<I, O> converter, final Predicate<I> matcher) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new Iterator<O>(){
                    private boolean consumed = true;
                    private final Iterator<I> iterator;
                    private I next;
                    private boolean valid;
                    {
                        this.iterator = input.iterator();
                        this.next = null;
                        this.valid = false;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.consumed) {
                            this.next = null;
                            this.valid = false;
                            while (this.iterator.hasNext() && !this.valid) {
                                this.next = this.iterator.next();
                                this.valid = matcher.test(this.next);
                            }
                            this.consumed = false;
                        }
                        return this.valid;
                    }

                    @Override
                    public O next() {
                        if (this.hasNext()) {
                            this.consumed = true;
                            return converter.apply(this.next);
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            public void useless() {
            }
        };
    }

    public static <T> Optional<T> first(Iterable<T> types) {
        return Iterables.nth(types, 0L);
    }

    public static <T> Optional<T> firstMatching(Iterable<T> types, Predicate<T> matcher) {
        return Iterables.first(Iterables.filter(types, matcher));
    }

    public static <T> Iterable<T> from(final Enumeration<T> types) {
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return types.hasMoreElements();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return types.nextElement();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> from(T ... types) {
        return Iterables.asList(types);
    }

    public static <T> T head(Iterable<T> types) {
        Iterator<T> iterator = types.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <T> Iterable<T> indexBasedIterable(final long size, final LongFunction<T> supplier) {
        return () -> new Iterator<T>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return this.index < size;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return supplier.apply(this.index++);
            }
        };
    }

    public static boolean isEmpty(Iterable<?> types) {
        if (types instanceof Collection) {
            return ((Collection)types).isEmpty();
        }
        return !types.iterator().hasNext();
    }

    public static <T> Iterable<T> iterable(T ... types) {
        return Iterables.indexBasedIterable(types.length, index -> types[(int)index]);
    }

    public static <T> Iterable<T> join(final T head, final Iterable<T> tail) {
        return () -> new Iterator<T>(){
            private boolean headConsumed;
            private final Iterator tailIterator;
            {
                this.tailIterator = tail.iterator();
                this.headConsumed = false;
            }

            @Override
            public boolean hasNext() {
                return !this.headConsumed || this.tailIterator.hasNext();
            }

            @Override
            public T next() {
                if (this.headConsumed) {
                    return this.tailIterator.next();
                }
                this.headConsumed = true;
                return head;
            }
        };
    }

    public static <T> Optional<T> last(Iterable<T> types) {
        Object result = null;
        if (types instanceof List) {
            List list = (List)types;
            if (!list.isEmpty()) {
                result = list.get(list.size() - 1);
            }
        } else {
            for (T type : types) {
                result = type;
            }
        }
        return Optional.ofNullable(result);
    }

    public static <T> Optional<T> lastMatching(Iterable<T> types, Predicate<T> matcher) {
        return Iterables.last(Iterables.filter(types, matcher));
    }

    public static <T> Optional<T> nth(Iterable<T> types, long index) {
        Object result;
        long counter = 0L;
        Iterator<T> iterator = types.iterator();
        Object v0 = result = iterator.hasNext() ? iterator.next() : null;
        while (counter++ < index) {
            if (iterator.hasNext()) {
                result = iterator.next();
                continue;
            }
            result = null;
            break;
        }
        return Optional.ofNullable(result);
    }

    public static <T> StreamIterable<T> parallelStream(Iterable<T> source) {
        return new StreamIterable<T>(source, true);
    }

    public static <T> void print(Iterable<T> input, String name) {
        System.out.println(Iterables.toString(input, name));
    }

    public static <T> long size(Iterable<T> types) {
        if (types instanceof Collection) {
            return ((Collection)types).size();
        }
        return Iterables.count(types, type -> 1L);
    }

    public static <T> StreamIterable<T> stream(Iterable<T> source) {
        return new StreamIterable<T>(source);
    }

    public static <T> Iterable<T> tail(Iterable<T> types) {
        Iterator iterator = types.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        return () -> iterator;
    }

    @SafeVarargs
    public static <T> List<T> toList(T ... types) {
        return Iterables.asList(types);
    }

    public static <T> String toString(Iterable<T> input, String name) {
        return Iterables.toString(input, name, ", ");
    }

    public static <T> String toString(Iterable<T> input, String name, String separator) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(name);
        builder.append(": ");
        long index = 0L;
        for (T type : input) {
            if (index > 0L) {
                builder.append(separator);
            }
            builder.append(type.toString());
            ++index;
        }
        builder.append("]");
        return builder.toString();
    }

    public static <I, O> Iterable<O> translate(Iterable<I> input, Function<I, O> converter) {
        return Iterables.filterTranslate(input, converter, item -> true);
    }

    public static <I, O> Iterable<O> translateFilter(Iterable<I> input, Function<I, O> converter, Predicate<O> matcher) {
        return Iterables.filter(Iterables.translate(input, converter), matcher);
    }

    public static <I, O> Iterable<O> translateMulti(Iterable<I> iterableIn, Function<I, Iterable<? extends O>> converter) {
        return new MultiIterable<O>(Iterables.translate(iterableIn, converter));
    }

    public static <T> Iterable<T> truncate(Iterable<T> types, int startIndex, int indexFromEnd) {
        return new SubIterable<T>(types, startIndex, indexFromEnd);
    }

    private Iterables() {
    }
}

