/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.utilities.collections.ImmutableListCollector;
import org.openstreetmap.atlas.utilities.collections.UnmodifiableSortedMapCollector;
import org.openstreetmap.atlas.utilities.collections.UnmodifiableSortedSetCollector;

public final class EnhancedCollectors {
    public static <T, K, A, R> Collector<T, ?, R> flatMapping(Function<? super T, ? extends Stream<? extends K>> mapper, Collector<? super K, A, R> downstream) {
        BiConsumer accumulator = downstream.accumulator();
        return Collector.of(downstream.supplier(), (itemA, itemT) -> {
            try (Stream s2 = (Stream)mapper.apply(itemT);){
                if (s2 != null) {
                    s2.forEachOrdered(u -> accumulator.accept((Object)itemA, (Object)u));
                }
            }
        }, downstream.combiner(), downstream.finisher(), (Collector.Characteristics[])downstream.characteristics().stream().toArray(Collector.Characteristics[]::new));
    }

    public static <T extends Comparable<T>> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return new ImmutableListCollector();
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (key, value) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", key));
        }, LinkedHashMap::new);
    }

    public static <T, K extends Comparable<K>, U> Collector<T, ?, SortedMap<K, U>> toUnmodifiableSortedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return new UnmodifiableSortedMapCollector<T, K, U>(keyMapper, valueMapper);
    }

    public static <T extends Comparable<T>> Collector<T, ?, SortedSet<T>> toUnmodifiableSortedSet() {
        return new UnmodifiableSortedSetCollector();
    }

    private EnhancedCollectors() {
    }
}

