/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations.base;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.openstreetmap.atlas.utilities.cli.operations.base.OperationResults;

public class SCPOperationResults
implements OperationResults {
    private final String destination;
    private long end = -1L;
    private String output;
    private int returnValue;
    private final String source;
    private long start = System.currentTimeMillis();

    SCPOperationResults(String source, String destination) {
        this.source = source;
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    @Override
    public Duration getElapsedTime() {
        if (this.end == -1L) {
            this.end = System.currentTimeMillis();
        }
        return Duration.of(this.end - this.start, ChronoUnit.MILLIS);
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    @Override
    public int getReturnValue() {
        return this.returnValue;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return String.format("%d\n%s\n", this.getReturnValue(), this.getOutput());
    }

    SCPOperationResults finish(String output, int returnCode) {
        this.output = output;
        this.returnValue = returnCode;
        this.getElapsedTime();
        return this;
    }
}

