/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations.base;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.openstreetmap.atlas.utilities.cli.operations.base.RemoteObject;
import org.openstreetmap.atlas.utilities.cli.operations.base.SCPOperationResults;

public class SCPOperation {
    private static final String QUIET_ARG = "-q";
    private static final String SCP_COMMAND = "scp";
    private static final String PORT_OVERRIDE = "-P";
    private Optional<Integer> possiblePortNumber = Optional.empty();

    public SCPOperationResults copy(Path fromLocal, RemoteObject toRemote) throws IOException, InterruptedException {
        return this.copy(fromLocal.toString(), toRemote.toString());
    }

    public SCPOperationResults copy(RemoteObject fromRemote, Path toLocal) throws IOException, InterruptedException {
        return this.copy(fromRemote.toString(), toLocal.toString());
    }

    public SCPOperationResults copy(RemoteObject fromRemote, RemoteObject toRemote) throws IOException, InterruptedException {
        return this.copy(fromRemote.toString(), toRemote.toString());
    }

    public SCPOperation onPort(int portNumber) {
        this.possiblePortNumber = Optional.of(portNumber);
        return this;
    }

    private SCPOperationResults copy(String fromResource, String toResource) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(SCP_COMMAND);
        args.add(QUIET_ARG);
        this.possiblePortNumber.ifPresent(portNumber -> {
            args.add(PORT_OVERRIDE);
            args.add(String.valueOf(portNumber));
        });
        args.add(fromResource);
        args.add(toResource);
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.redirectErrorStream(true);
        SCPOperationResults results = new SCPOperationResults(fromResource, toResource);
        Process process = builder.start();
        String remoteOutput = new String(IOUtils.toByteArray(process.getInputStream()));
        int returnCode = process.waitFor();
        return results.finish(remoteOutput, returnCode);
    }
}

