/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations;

import java.io.IOException;
import java.nio.file.Path;
import org.openstreetmap.atlas.utilities.cli.operations.AbstractOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperationResults;

public class CheckIfFileExistsOperation
extends AbstractOperation {
    @Override
    public CheckIfFileExistsOperation asUser(String username) {
        super.asUser(username);
        return this;
    }

    public boolean exists(Path remotePath) throws InterruptedException, IOException {
        if (remotePath == null) {
            throw new IllegalArgumentException("remotePath can't be null");
        }
        this.ssh().addArgs("stat", remotePath.toString());
        SSHOperationResults results = this.handleResults(this.ssh().execute());
        return !results.getOutput().contains("No such file or directory");
    }

    @Override
    public CheckIfFileExistsOperation onHost(String host) {
        super.onHost(host);
        return this;
    }

    @Override
    public CheckIfFileExistsOperation onPort(int portNumber) {
        super.onPort(portNumber);
        return this;
    }
}

