/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class StringArray
extends LargeArray<String> {
    private static final long serialVersionUID = 5462179570391723788L;

    public StringArray(long maximumSize) {
        super(maximumSize);
    }

    public StringArray(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    @Override
    protected PrimitiveArray<String> getNewArray(int size) {
        return new StringPrimitiveArray(size);
    }

    public static class StringPrimitiveArray
    extends PrimitiveArray<String> {
        private static final long serialVersionUID = 6050182547243598715L;
        private final String[] array;

        public StringPrimitiveArray(int size) {
            super(size);
            this.array = new String[size];
        }

        @Override
        public String get(int index) {
            return this.array[index];
        }

        @Override
        public PrimitiveArray<String> getNewArray(int size) {
            return new StringPrimitiveArray(size);
        }

        @Override
        public void set(int index, String item) {
            this.array[index] = item;
        }
    }
}

