/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.StringCompressedPolygon;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoPolygonArrayAdapter;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PolyLineArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class PolygonArray
extends LargeArray<Polygon>
implements ProtoSerializable {
    private static final long serialVersionUID = -2337695414673604456L;

    public PolygonArray(long maximumSize) {
        super(maximumSize);
    }

    public PolygonArray(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    private PolygonArray() {
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoPolygonArrayAdapter();
    }

    @Override
    protected PrimitiveArray<Polygon> getNewArray(int size) {
        return new PrimitivePolygonArray(size);
    }

    public static class PrimitivePolygonArray
    extends PolyLineArray.PrimitivePointsArray<Polygon> {
        private static final long serialVersionUID = 1115133908622542632L;

        public PrimitivePolygonArray(int size) {
            super(size);
        }

        @Override
        public Polygon get(int index) {
            return new StringCompressedPolygon(this.getEncodings()[index]).asPolygon();
        }

        @Override
        public PrimitiveArray<Polygon> getNewArray(int size) {
            return new PrimitivePolygonArray(size);
        }
    }
}

