/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class BooleanArray
extends LargeArray<Boolean> {
    private static final long serialVersionUID = -6015640040842668449L;

    public BooleanArray(long maximumSize) {
        super(maximumSize);
    }

    public BooleanArray(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    @Override
    protected PrimitiveArray<Boolean> getNewArray(int size) {
        return new BooleanPrimitiveArray(size);
    }

    public static class BooleanPrimitiveArray
    extends PrimitiveArray<Boolean> {
        private static final long serialVersionUID = -3932998946137654750L;
        private final boolean[] array = new boolean[this.size()];

        public BooleanPrimitiveArray(int size) {
            super(size);
        }

        @Override
        public Boolean get(int index) {
            return this.array[index];
        }

        @Override
        public PrimitiveArray<Boolean> getNewArray(int size) {
            return new BooleanPrimitiveArray(size);
        }

        @Override
        public void set(int index, Boolean item) {
            this.array[index] = item;
        }
    }
}

