/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import java.util.Collection;

public final class Arrays {
    public static int[] addNewItem(int[] existing, int newValue) {
        int[] result = new int[existing.length + 1];
        for (int i = 0; i < existing.length; ++i) {
            result[i] = existing[i];
        }
        result[result.length - 1] = newValue;
        return result;
    }

    public static long[] addNewItem(long[] existing, long newValue) {
        long[] result = new long[existing.length + 1];
        for (int i = 0; i < existing.length; ++i) {
            result[i] = existing[i];
        }
        result[result.length - 1] = newValue;
        return result;
    }

    public static long[] addNewItemAndResizeOnlyIfNecessary(long[] existing, long newValue, int index) {
        long[] result = existing;
        if (index >= existing.length) {
            result = java.util.Arrays.copyOf(existing, existing.length * 2);
        }
        result[index] = newValue;
        return result;
    }

    public static long[] toArray(Collection<Long> list) {
        long[] result = new long[list.size()];
        int index = 0;
        for (Long value : list) {
            result[index++] = value;
        }
        return result;
    }

    public static long[] trimToSize(long[] existing, int size) {
        if (size <= 0) {
            return new long[0];
        }
        return java.util.Arrays.copyOfRange(existing, 0, size - 1);
    }

    private Arrays() {
    }
}

