/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.validation;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.locale.IsoLanguage;
import org.openstreetmap.atlas.tags.LocalizedTagNameWithOptionalDate;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.TagValue;
import org.openstreetmap.atlas.tags.annotations.TagValueAs;
import org.openstreetmap.atlas.tags.annotations.validation.DoubleValidator;
import org.openstreetmap.atlas.tags.annotations.validation.ExactMatchValidator;
import org.openstreetmap.atlas.tags.annotations.validation.ISO2CountryValidator;
import org.openstreetmap.atlas.tags.annotations.validation.ISO3CountryValidator;
import org.openstreetmap.atlas.tags.annotations.validation.LengthValidator;
import org.openstreetmap.atlas.tags.annotations.validation.LongValidator;
import org.openstreetmap.atlas.tags.annotations.validation.NonEmptyStringValidator;
import org.openstreetmap.atlas.tags.annotations.validation.NoneValidator;
import org.openstreetmap.atlas.tags.annotations.validation.NumericValidator;
import org.openstreetmap.atlas.tags.annotations.validation.OrdinalValidator;
import org.openstreetmap.atlas.tags.annotations.validation.SpeedValidator;
import org.openstreetmap.atlas.tags.annotations.validation.TagValidator;
import org.openstreetmap.atlas.tags.annotations.validation.TimestampValidator;
import org.openstreetmap.atlas.tags.annotations.validation.URIValidator;
import org.openstreetmap.atlas.tags.cache.CachingValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validators {
    private static final Logger logger = LoggerFactory.getLogger(Validators.class);
    private final ValidatorMap validators;
    private final EnumMap<Tag.Validation, Class<? extends TagValidator>> validatorTypes = new EnumMap(Tag.Validation.class);

    public static String findTagNameIn(Class<?> tagClass) {
        Optional<TagKeySearchResults> tagName = TagKeySearch.findTagKeyIn(tagClass);
        if (tagName.isPresent()) {
            return tagName.get().getKeyName();
        }
        throw new IllegalArgumentException(String.format("key must be declared in class: %s", tagClass.getName()));
    }

    public static <T extends Enum<T>> Optional<T> from(Class<?> tagType, Class<T> enumType, Taggable taggable) {
        Tag tag = tagType.getDeclaredAnnotation(Tag.class);
        if (tag != null && Stream.of(tag.with()).anyMatch(possible -> possible == enumType)) {
            return Validators.fromHelper(Validators.findTagNameIn(tagType), enumType, taggable);
        }
        return Optional.empty();
    }

    public static <T extends Enum<T>> Optional<T> from(Class<T> tagType, Taggable taggable) {
        return CachingValidator.getInstance().from(tagType, taggable);
    }

    public static <T extends Enum<T>> Optional<T> fromAnnotation(Class<T> tagType, Taggable taggable) {
        if (tagType.getDeclaredAnnotation(Tag.class) != null) {
            return Validators.fromHelper(Validators.findTagNameIn(tagType), tagType, taggable);
        }
        return Optional.empty();
    }

    public static boolean hasLocalizedTagKey(Class<?> tagType) {
        if (tagType == null) {
            throw new IllegalArgumentException("tagType can't be null");
        }
        Optional<TagKeySearchResults> tagKey = TagKeySearch.findTagKeyIn(tagType);
        if (!tagKey.isPresent()) {
            throw new IllegalArgumentException(String.format("%s isn't a known key", tagType.getName()));
        }
        return tagKey.get().getTagKey().value() == TagKey.KeyType.LOCALIZED;
    }

    public static Predicate<Taggable> hasValuesFor(Class<?> ... tagTypes) {
        if (tagTypes.length == 0) {
            return taggable -> false;
        }
        return taggable -> Validators.hasValuesFor(taggable, tagTypes);
    }

    public static boolean hasValuesFor(Taggable taggable, Class<?> ... tagTypes) {
        for (Class<?> tagType : tagTypes) {
            if (taggable.getTag(Validators.findTagNameIn(tagType)).isPresent()) continue;
            return false;
        }
        return true;
    }

    public static <T extends Enum<T>> boolean isNotOfType(Taggable taggable, Class<T> type, T ... values) {
        Optional<T> possibleRealValue = Validators.from(type, taggable);
        if (!possibleRealValue.isPresent()) {
            return false;
        }
        Enum realValue = (Enum)possibleRealValue.get();
        for (T searching : values) {
            if (realValue != searching) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isOfSameType(Taggable firstTaggable, Taggable secondTaggable, Class<T> type) {
        String key = Validators.findTagNameIn(type);
        return firstTaggable.getTag(key).flatMap(oneTag -> secondTaggable.getTag(key).map(oneTag::equals)).orElse(false);
    }

    public static <T extends Enum<T>> boolean isOfType(Taggable taggable, Class<T> type, T ... values) {
        Optional<T> possibleRealValue = Validators.from(type, taggable);
        if (!possibleRealValue.isPresent()) {
            return false;
        }
        Enum realValue = (Enum)possibleRealValue.get();
        for (T searching : values) {
            if (realValue != searching) continue;
            return true;
        }
        return false;
    }

    public static Optional<String> localizeKeyName(Class<?> tagType, Optional<IsoLanguage> language, Taggable.TagSearchOption ... searchOptions) {
        if (tagType == null) {
            throw new IllegalArgumentException("tagType can't be null");
        }
        Optional<TagKeySearchResults> tagKey = TagKeySearch.findTagKeyIn(tagType);
        if (!tagKey.isPresent()) {
            throw new IllegalArgumentException(String.format("%s isn't a known key", tagType.getName()));
        }
        EnumSet<Taggable.TagSearchOption> searchOptionSet = searchOptions.length > 0 ? EnumSet.copyOf(Arrays.asList(searchOptions)) : EnumSet.noneOf(Taggable.TagSearchOption.class);
        TagKeySearchResults data = tagKey.get();
        Optional<String> value = Optional.empty();
        if (language.isPresent() && (data.getTagKey().value() == TagKey.KeyType.LOCALIZED || searchOptionSet.contains((Object)Taggable.TagSearchOption.FORCE_ALL_LOCALIZED_ONLY))) {
            value = Optional.of(String.format("%s:%s", data.getKeyName(), language.get().getLanguageCode()));
        }
        if (!value.isPresent()) {
            value = Optional.of(data.getKeyName());
        }
        return value;
    }

    public static Map<String, String> toMap(Enum<?> ... values) {
        return Arrays.asList(values).stream().collect(Collectors.toMap((? super T value) -> Validators.findTagNameIn(value.getClass()), (? super T value) -> value.name().toLowerCase()));
    }

    private static String enumConstantToValue(Enum<?> constant) {
        try {
            Field field = constant.getDeclaringClass().getField(constant.name());
            TagValueAs substitutedValue = field.getAnnotation(TagValueAs.class);
            return substitutedValue == null ? ((Enum)field.get(null)).name().toLowerCase() : substitutedValue.value();
        }
        catch (IllegalAccessException | NoSuchFieldException oops) {
            throw new CoreException("{} can't access field value", constant, oops);
        }
    }

    private static <T extends Enum<T>> Optional<T> fromHelper(String tagName, Class<T> enumType, Taggable taggable) {
        Optional<String> tagValue;
        if (tagName != null && (tagValue = taggable.getTag(tagName)).isPresent()) {
            String internedValue = tagValue.get().toUpperCase().intern();
            try {
                T enumValue = Enum.valueOf(enumType, internedValue);
                return Optional.of(enumValue);
            }
            catch (IllegalArgumentException badArgument) {
                return Validators.fromMatchingHelper(tagName, enumType, internedValue);
            }
        }
        return Optional.empty();
    }

    private static <T extends Enum<T>> Optional<T> fromMatchingHelper(String tagName, Class<T> enumType, String internedValue) {
        try {
            for (Enum enumValue : (Enum[])enumType.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                if (!Validators.matches(enumValue, internedValue)) continue;
                return Optional.of(enumValue);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException anImpossibleError) {
            logger.error("{} doesn't have a values method, or it couldn't be called: impossible", (Object)tagName, (Object)anImpossibleError);
        }
        return Optional.empty();
    }

    private static boolean matches(Enum<?> constant, String value) {
        try {
            Field field = constant.getDeclaringClass().getField(constant.name());
            TagValueAs substitutedValue = field.getAnnotation(TagValueAs.class);
            String comparisonString = substitutedValue != null ? substitutedValue.value() : constant.name();
            return comparisonString.toUpperCase().intern() == value.intern();
        }
        catch (NoSuchFieldException oops) {
            throw new CoreException("{} can't access field value", constant, oops);
        }
    }

    public Validators(Class<?> childrenOf) {
        this(childrenOf.getPackage().getName());
    }

    public Validators(String packageName) {
        this.validators = new ValidatorMap();
        this.fillValidatorTypes(this.validatorTypes);
        ArrayList klasses = new ArrayList();
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().whitelistPackages(packageName).scan();){
            ClassInfoList tagClassInfoList = scanResult.getClassesWithAnnotation("org.openstreetmap.atlas.tags.annotations.Tag");
            tagClassInfoList.loadClasses().forEach(klasses::add);
        }
        klasses.stream().forEach(this::processClass);
    }

    public boolean canValidate(String key) {
        return this.validators.canValidate(key);
    }

    public Optional<Class<?>> findClassDefining(String tag) {
        return Optional.ofNullable(this.validators.classFor(tag));
    }

    public Optional<String> getTagInfo(String tagName) {
        Class<?> tagClass = this.validators.classFor(tagName);
        if (tagClass != null) {
            Tag tag = tagClass.getAnnotation(Tag.class);
            if (tag.taginfo().equals("")) {
                return Optional.empty();
            }
            return Optional.of(tag.taginfo());
        }
        return Optional.empty();
    }

    public TagValidator getValidatorFor(String key) {
        return this.validators.validatorFor(key);
    }

    public boolean isValidFor(String key, String value) {
        return this.canValidate(key) && this.getValidatorFor(key).isValid(value);
    }

    protected void fillValidatorTypes(EnumMap<Tag.Validation, Class<? extends TagValidator>> validatorTypes) {
        validatorTypes.put(Tag.Validation.DOUBLE, DoubleValidator.class);
        validatorTypes.put(Tag.Validation.LONG, LongValidator.class);
        validatorTypes.put(Tag.Validation.MATCH, ExactMatchValidator.class);
        validatorTypes.put(Tag.Validation.TIMESTAMP, TimestampValidator.class);
        validatorTypes.put(Tag.Validation.NON_EMPTY_STRING, NonEmptyStringValidator.class);
        validatorTypes.put(Tag.Validation.NONE, NoneValidator.class);
        validatorTypes.put(Tag.Validation.ISO3_COUNTRY, ISO3CountryValidator.class);
        validatorTypes.put(Tag.Validation.ISO2_COUNTRY, ISO2CountryValidator.class);
        validatorTypes.put(Tag.Validation.ORDINAL, OrdinalValidator.class);
        validatorTypes.put(Tag.Validation.URI, URIValidator.class);
        validatorTypes.put(Tag.Validation.SPEED, SpeedValidator.class);
        validatorTypes.put(Tag.Validation.LENGTH, LengthValidator.class);
    }

    private TagValidator createValidatorFor(Tag.Validation validation) {
        Class<? extends TagValidator> validatorClass = this.validatorTypes.get((Object)validation);
        if (validatorClass == null) {
            throw new IllegalArgumentException(String.format("%s is an unsupported validator", new Object[]{validation}));
        }
        try {
            return validatorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException oops) {
            throw new IllegalArgumentException(String.format("%s is an unsupported validator", new Object[]{validation}), oops);
        }
    }

    private TagValidator fillEnumerationValues(ExactMatchValidator validator, Class<?> tagClass) {
        for (Enum enumValue : (Enum[])tagClass.getEnumConstants()) {
            validator.withValues(Validators.enumConstantToValue(enumValue));
        }
        return validator;
    }

    private void fillExactMatches(ExactMatchValidator validator, Field[] fields) {
        for (Field field : fields) {
            TagValue tagValue = field.getAnnotation(TagValue.class);
            if (tagValue == null || !field.getType().isAssignableFrom(String.class)) continue;
            try {
                String returnValue = (String)field.get(null);
                if (returnValue == null || returnValue.trim().length() == 0) {
                    throw new IllegalArgumentException("key can't be empty");
                }
                switch (tagValue.value()) {
                    case REGEX: {
                        validator.withRegularExpressions(returnValue);
                        break;
                    }
                    case EXACT: {
                        validator.withValues(returnValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("%s is an unsupported value type", new Object[]{tagValue.value()}));
                    }
                }
            }
            catch (IllegalAccessException oops) {
                throw new IllegalArgumentException(oops);
            }
        }
    }

    private void processClass(Class<?> tagClass) {
        Tag tag = tagClass.getAnnotation(Tag.class);
        if (tag != null) {
            TagValidator validator = this.createValidatorFor(tag.value());
            TagKeySearch.findTagKeyIn(tagClass).ifPresent(results -> {
                if (validator instanceof ExactMatchValidator) {
                    ExactMatchValidator exactMatch = (ExactMatchValidator)validator;
                    this.fillExactMatches(exactMatch, tagClass.getDeclaredFields());
                    if (tagClass.isEnum()) {
                        this.fillEnumerationValues(exactMatch, tagClass);
                    }
                    for (Class<? extends Enum<?>> withClass : tag.with()) {
                        this.fillEnumerationValues(exactMatch, withClass);
                    }
                }
                if (validator instanceof NumericValidator) {
                    NumericValidator numeric = (NumericValidator)validator;
                    numeric.setRange(tag.range().min(), tag.range().max());
                    for (long excludeMe : tag.range().exclude()) {
                        numeric.excludeValue(excludeMe);
                    }
                }
                this.validators.put(tagClass, results.getKeyName(), results.getTagKey(), validator);
            });
        }
    }

    private static final class ValidatorMap {
        private final Map<String, TagValidator> validators = new HashMap<String, TagValidator>();
        private final Map<String, TagValidator> localizedValidators = new HashMap<String, TagValidator>();
        private final Map<String, Class<?>> origins = new HashMap();

        ValidatorMap() {
        }

        boolean canValidate(String name) {
            return this.validatorFor(name) != null;
        }

        Class<?> classFor(String name) {
            return this.origins.get(name);
        }

        void put(Class<?> tagClass, String name, TagKey tagKey, TagValidator validator) {
            if (tagKey.value() == TagKey.KeyType.EXACT) {
                this.validators.put(name, validator);
            } else {
                this.localizedValidators.put(name, validator);
            }
            this.origins.put(name, tagClass);
        }

        TagValidator validatorFor(String name) {
            TagValidator validator = this.validators.get(name);
            if (validator == null) {
                LocalizedTagNameWithOptionalDate localizedName = new LocalizedTagNameWithOptionalDate(name);
                validator = this.localizedValidators.get(localizedName.getName());
            }
            return validator;
        }
    }

    public static final class TagKeySearchResults {
        private final Tag tag;
        private final TagKey key;
        private final String keyName;

        private TagKeySearchResults(Tag tag, TagKey key, String keyName) {
            this.tag = tag;
            this.key = key;
            this.keyName = keyName;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public Tag getTag() {
            return this.tag;
        }

        public TagKey getTagKey() {
            return this.key;
        }
    }

    public static final class TagKeySearch {
        public static Optional<TagKeySearchResults> findTagKeyIn(Class<?> tagClass) {
            Tag tag = tagClass.getDeclaredAnnotation(Tag.class);
            for (Field field : tagClass.getDeclaredFields()) {
                TagKey tagKey = field.getAnnotation(TagKey.class);
                if (tagKey == null || !field.getType().isAssignableFrom(String.class)) continue;
                try {
                    String returnValue = (String)field.get(null);
                    if (returnValue == null || returnValue.trim().length() == 0) {
                        throw new IllegalArgumentException(String.format("%s is missing a key", tagClass.getName()));
                    }
                    return Optional.of(new TagKeySearchResults(tag, tagKey, returnValue));
                }
                catch (IllegalAccessException oops) {
                    throw new IllegalArgumentException(String.format("Check the source code for %s: the @TagKey is probably not a public static final String constant", tagClass.getName()), oops);
                }
            }
            return Optional.empty();
        }
    }
}

