/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.validation;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.tags.annotations.validation.DoubleValidator;
import org.openstreetmap.atlas.tags.annotations.validation.TagValidator;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class LengthValidator
implements TagValidator {
    private static final DoubleValidator DOUBLE_VALIDATOR = new DoubleValidator();

    @Override
    public boolean isValid(String value) {
        int inchesIndex;
        int feetIndex;
        Matcher suffixMatcher = Pattern.compile(String.format("(\\d+.?\\d*) (%s)", String.join((CharSequence)"|", Arrays.stream(Distance.UnitAbbreviations.values()).map(Enum::toString).collect(Collectors.toList())))).matcher(value.toUpperCase());
        boolean result = suffixMatcher.matches() ? DOUBLE_VALIDATOR.isValid(suffixMatcher.group(1)) : ((feetIndex = value.indexOf("'")) > -1 ? (DOUBLE_VALIDATOR.isValid(value.substring(0, feetIndex)) ? (feetIndex + 1 < value.length() ? ((inchesIndex = value.indexOf("\"", feetIndex + 1)) > -1 ? this.validateInchesAndTail(value, feetIndex + 1, inchesIndex) : StringUtils.isBlank(value.substring(feetIndex + 1, value.length()))) : true) : false) : ((inchesIndex = value.indexOf("\"")) > -1 ? this.validateInchesAndTail(value, 0, inchesIndex) : DOUBLE_VALIDATOR.isValid(value)));
        return result;
    }

    private boolean validateInchesAndTail(String value, int start, int index) {
        return DOUBLE_VALIDATOR.isValid(value.substring(start, index)) && (index + 1 == value.length() || StringUtils.isBlank(value.substring(index + 1, value.length())));
    }
}

