/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.validation;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.tags.annotations.validation.TagValidator;

public class ISO2CountryValidator
implements TagValidator {
    private static Set<String> validISOCountries = Arrays.asList(Locale.getAvailableLocales()).stream().filter(ISO2CountryValidator::hasISO2Country).map(Locale::getCountry).collect(Collectors.toSet());

    private static boolean hasISO2Country(Locale locale) {
        String country = locale.getCountry();
        return StringUtils.isNotBlank(country) && country.length() == 2;
    }

    @Override
    public boolean isValid(String value) {
        return validISOCountries.contains(value);
    }
}

