/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.extraction;

import java.util.Optional;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.extraction.TagExtractor;
import org.openstreetmap.atlas.tags.annotations.validation.LengthValidator;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class LengthExtractor
implements TagExtractor {
    private static final LengthValidator VALIDATOR = new LengthValidator();
    private static final String SINGLE_SPACE = " ";

    public static Optional<Distance> validateAndExtract(String value) {
        String uppercaseValue = value.toUpperCase();
        if (VALIDATOR.isValid(uppercaseValue)) {
            if (uppercaseValue.endsWith(SINGLE_SPACE + Distance.UnitAbbreviations.M)) {
                return Optional.of(Distance.meters(Double.valueOf(uppercaseValue.substring(0, uppercaseValue.lastIndexOf(SINGLE_SPACE + Distance.UnitAbbreviations.M)))));
            }
            if (uppercaseValue.endsWith(SINGLE_SPACE + Distance.UnitAbbreviations.KM)) {
                return Optional.of(Distance.kilometers(Double.valueOf(uppercaseValue.substring(0, uppercaseValue.lastIndexOf(SINGLE_SPACE + Distance.UnitAbbreviations.KM)))));
            }
            if (uppercaseValue.endsWith(SINGLE_SPACE + Distance.UnitAbbreviations.MI)) {
                return Optional.of(Distance.miles(Double.valueOf(uppercaseValue.substring(0, uppercaseValue.lastIndexOf(SINGLE_SPACE + Distance.UnitAbbreviations.MI)))));
            }
            if (uppercaseValue.endsWith(SINGLE_SPACE + Distance.UnitAbbreviations.NMI)) {
                return Optional.of(Distance.nauticalMiles(Double.valueOf(uppercaseValue.substring(0, uppercaseValue.lastIndexOf(SINGLE_SPACE + Distance.UnitAbbreviations.NMI)))));
            }
            if (uppercaseValue.contains("\"")) {
                StringList split = StringList.split(uppercaseValue, "'");
                if (split.size() == 2) {
                    return Optional.of(Distance.feetAndInches(Double.valueOf(split.get(0)), Double.valueOf(split.get(1).substring(0, split.get(1).lastIndexOf("\"")))));
                }
                if (split.size() == 1) {
                    return Optional.of(Distance.inches(Double.valueOf(split.get(0).substring(0, split.get(0).lastIndexOf("\"")))));
                }
            } else {
                if (uppercaseValue.contains("'")) {
                    return Optional.of(Distance.feet(Double.valueOf(uppercaseValue.substring(0, uppercaseValue.lastIndexOf("'")))));
                }
                return Optional.of(Distance.meters(Double.valueOf(uppercaseValue)));
            }
        }
        return Optional.empty();
    }

    public Optional<Distance> validateAndExtract(String value, Tag tag) {
        return LengthExtractor.validateAndExtract(value);
    }
}

