/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.extraction.OrdinalExtractor;

@Tag(value=Tag.Validation.ORDINAL, range=@Tag.Range(min=1L, max=99L), taginfo="https://taginfo.openstreetmap.org/keys/protect_class", osm="https://wiki.openstreetmap.org/wiki/Key:protect_class")
public interface ProtectClassTag {
    @TagKey
    public static final String KEY = "protect_class";

    public static Optional<Integer> getValue(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            OrdinalExtractor extractor = new OrdinalExtractor();
            return extractor.validateAndExtract(tagValue.get(), ProtectClassTag.class.getDeclaredAnnotation(Tag.class));
        }
        return Optional.empty();
    }
}

