/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.TagValue;
import org.openstreetmap.atlas.tags.annotations.extraction.LengthExtractor;
import org.openstreetmap.atlas.utilities.scalars.Distance;

@Tag(taginfo="http://taginfo.openstreetmap.org/keys/maxwidth#values", osm="http://wiki.openstreetmap.org/wiki/Key:maxwidth")
public interface MaxWidthTag {
    @TagKey
    public static final String KEY = "maxwidth";
    @TagValue(value=TagValue.ValueType.REGEX)
    public static final String METERS = "(\\d+(\\.\\d+)?|\\.\\d+)(\\sm)?";
    @TagValue(value=TagValue.ValueType.REGEX)
    public static final String FEET = "\\d'\\d\"";

    public static Optional<Distance> get(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            return LengthExtractor.validateAndExtract(tagValue.get());
        }
        return Optional.empty();
    }
}

