/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.extraction.OrdinalExtractor;

@Tag(value=Tag.Validation.ORDINAL, range=@Tag.Range(min=1L, max=50L), taginfo="http://taginfo.openstreetmap.org/keys/lanes#values", osm="http://wiki.openstreetmap.org/wiki/Lanes")
public interface LanesTag {
    @TagKey
    public static final String KEY = "lanes";

    public static Optional<Integer> numberOfLanes(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            OrdinalExtractor extractor = new OrdinalExtractor();
            return extractor.validateAndExtract(tagValue.get(), LanesTag.class.getDeclaredAnnotation(Tag.class));
        }
        return Optional.empty();
    }
}

