/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import com.google.common.collect.EnumBiMap;
import java.util.EnumSet;
import java.util.Optional;
import org.openstreetmap.atlas.tags.AreaTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;

@Tag(taginfo="http://taginfo.openstreetmap.org/keys/highway#values", osm="http://wiki.openstreetmap.org/wiki/Key:highway")
public enum HighwayTag {
    MOTORWAY,
    MOTORWAY_LINK,
    TRUNK,
    TRUNK_LINK,
    PRIMARY,
    PRIMARY_LINK,
    SECONDARY,
    SECONDARY_LINK,
    TERTIARY,
    TERTIARY_LINK,
    UNCLASSIFIED,
    RESIDENTIAL,
    SERVICE,
    TRACK,
    LIVING_STREET,
    PEDESTRIAN,
    BUS_GUIDEWAY,
    RACEWAY,
    ROAD,
    CYCLEWAY,
    FOOTWAY,
    BRIDLEWAY,
    STEPS,
    PATH,
    PROPOSED,
    CONSTRUCTION,
    ESCAPE,
    BUS_STOP,
    CROSSING,
    ELEVATOR,
    EMERGENCY_ACCESS_POINT,
    GIVE_WAY,
    MINI_ROUNDABOUT,
    MOTORWAY_JUNCTION,
    PASSING_PLACE,
    REST_AREA,
    SPEED_CAMERA,
    STREET_LAMP,
    SERVICES,
    STOP,
    TRAFFIC_SIGNALS,
    TURNING_CIRCLE,
    PLATFORM,
    MILESTONE,
    TURNING_LOOP,
    CORRIDOR,
    NO,
    TOLL_GANTRY;

    @TagKey
    public static final String KEY = "highway";
    private static final EnumSet<HighwayTag> CORE_WAYS;
    private static final EnumSet<HighwayTag> METRICS_HIGHWAYS;
    private static final EnumSet<HighwayTag> CAR_NAVIGABLE_HIGHWAYS;
    private static final EnumSet<HighwayTag> PEDESTRIAN_NAVIGABLE_HIGHWAYS;
    private static final EnumBiMap<HighwayTag, HighwayTag> HIGHWAY_LINKS;

    public static Optional<HighwayTag> highwayTag(Taggable taggable) {
        return Validators.from(HighwayTag.class, taggable);
    }

    public static boolean isCarNavigableHighway(HighwayTag tag) {
        return CAR_NAVIGABLE_HIGHWAYS.contains((Object)tag);
    }

    public static boolean isCarNavigableHighway(Taggable taggable) {
        Optional<HighwayTag> highway = HighwayTag.highwayTag(taggable);
        return highway.isPresent() && CAR_NAVIGABLE_HIGHWAYS.contains((Object)highway.get());
    }

    public static boolean isCoreWay(Taggable taggable) {
        Optional<HighwayTag> highway = HighwayTag.highwayTag(taggable);
        return highway.isPresent() && CORE_WAYS.contains((Object)highway.get());
    }

    public static boolean isHighwayArea(Taggable taggable) {
        return Validators.isOfType((Taggable)taggable, HighwayTag.class, (Enum[])new HighwayTag[]{PEDESTRIAN, FOOTWAY}) && (Validators.isOfType((Taggable)taggable, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.YES}) || Validators.hasValuesFor(taggable, BuildingTag.class));
    }

    public static boolean isHighwayWithLink(Taggable taggable) {
        Optional<HighwayTag> highway = HighwayTag.highwayTag(taggable);
        return highway.isPresent() && HIGHWAY_LINKS.containsKey((Object)highway.get());
    }

    public static boolean isLinkHighway(HighwayTag tag) {
        return HIGHWAY_LINKS.containsValue((Object)tag);
    }

    public static boolean isLinkHighway(Taggable taggable) {
        Optional<HighwayTag> highway = HighwayTag.highwayTag(taggable);
        return highway.isPresent() && HIGHWAY_LINKS.containsValue((Object)highway.get());
    }

    public static boolean isMetricHighway(Taggable taggable) {
        Optional<HighwayTag> highway = HighwayTag.highwayTag(taggable);
        return highway.isPresent() && METRICS_HIGHWAYS.contains((Object)highway.get());
    }

    public static boolean isPedestrianCrossing(Taggable taggable) {
        return Validators.isOfType((Taggable)taggable, HighwayTag.class, (Enum[])new HighwayTag[]{CROSSING});
    }

    public static boolean isPedestrianNavigableHighway(Taggable taggable) {
        Optional<HighwayTag> highway = HighwayTag.highwayTag(taggable);
        return highway.isPresent() && PEDESTRIAN_NAVIGABLE_HIGHWAYS.contains((Object)highway.get());
    }

    public static Optional<HighwayTag> tag(Taggable taggable) {
        return Validators.from(HighwayTag.class, taggable);
    }

    public boolean canHaveLink() {
        return HIGHWAY_LINKS.containsKey((Object)this);
    }

    public Optional<HighwayTag> getHighwayFromLink() {
        return Optional.ofNullable((HighwayTag)((Object)HIGHWAY_LINKS.inverse().get((Object)this)));
    }

    public Optional<HighwayTag> getLinkFromHighway() {
        return Optional.ofNullable((HighwayTag)((Object)HIGHWAY_LINKS.get((Object)this)));
    }

    public String getTagValue() {
        return this.name().toLowerCase().intern();
    }

    public boolean isIdenticalClassification(HighwayTag tag) {
        return this == tag;
    }

    public boolean isLessImportantThan(HighwayTag other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessImportantThanOrEqualTo(HighwayTag other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isLink() {
        return HIGHWAY_LINKS.containsValue((Object)this);
    }

    public boolean isMoreImportantThan(HighwayTag other) {
        return this.compareTo(other) < 0;
    }

    public boolean isMoreImportantThanOrEqualTo(HighwayTag other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isOfEqualClassification(HighwayTag tag) {
        return this == tag || HIGHWAY_LINKS.get((Object)this) == tag || HIGHWAY_LINKS.inverse().get((Object)this) == tag;
    }

    static {
        CORE_WAYS = EnumSet.of(MOTORWAY, new HighwayTag[]{TRUNK, PRIMARY, SECONDARY, TERTIARY, UNCLASSIFIED, RESIDENTIAL, SERVICE, MOTORWAY_LINK, TRUNK_LINK, PRIMARY_LINK, SECONDARY_LINK, TERTIARY_LINK, LIVING_STREET, PEDESTRIAN, TRACK, BUS_GUIDEWAY, RACEWAY, ROAD, FOOTWAY, BRIDLEWAY, STEPS, PATH, CYCLEWAY, ESCAPE});
        METRICS_HIGHWAYS = EnumSet.of(MOTORWAY, new HighwayTag[]{TRUNK, PRIMARY, SECONDARY, TERTIARY, UNCLASSIFIED, RESIDENTIAL, SERVICE, MOTORWAY_LINK, TRUNK_LINK, PRIMARY_LINK, SECONDARY_LINK, TERTIARY_LINK, LIVING_STREET, PEDESTRIAN, TRACK, BUS_GUIDEWAY, FOOTWAY, BRIDLEWAY, STEPS, PATH, CYCLEWAY, ESCAPE});
        CAR_NAVIGABLE_HIGHWAYS = EnumSet.of(MOTORWAY, new HighwayTag[]{TRUNK, PRIMARY, SECONDARY, TERTIARY, UNCLASSIFIED, RESIDENTIAL, SERVICE, MOTORWAY_LINK, TRUNK_LINK, PRIMARY_LINK, SECONDARY_LINK, TERTIARY_LINK, LIVING_STREET, TRACK, ROAD});
        PEDESTRIAN_NAVIGABLE_HIGHWAYS = EnumSet.of(PEDESTRIAN, new HighwayTag[]{FOOTWAY, STEPS, PATH, CROSSING, PLATFORM, ELEVATOR, CORRIDOR});
        HIGHWAY_LINKS = EnumBiMap.create(HighwayTag.class, HighwayTag.class);
        HIGHWAY_LINKS.put(MOTORWAY, MOTORWAY_LINK);
        HIGHWAY_LINKS.put(TRUNK, TRUNK_LINK);
        HIGHWAY_LINKS.put(PRIMARY, PRIMARY_LINK);
        HIGHWAY_LINKS.put(SECONDARY, SECONDARY_LINK);
        HIGHWAY_LINKS.put(TERTIARY, TERTIARY_LINK);
    }
}

