/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.geography.Altitude;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.extraction.AltitudeExtractor;

@Tag(value=Tag.Validation.LENGTH, taginfo="https://taginfo.openstreetmap.org/keys/building%3Aheight#values", osm="http://wiki.openstreetmap.org/wiki/Key:height")
public interface BuildingHeightTag {
    @TagKey
    public static final String KEY = "building:height";

    public static Optional<Altitude> get(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            return AltitudeExtractor.validateAndExtract(tagValue.get());
        }
        return Optional.empty();
    }
}

