/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.EnumSet;
import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;

@Tag(taginfo="http://taginfo.openstreetmap.org/keys/bridge#values", osm="http://wiki.openstreetmap.org/wiki/Key:bridge")
public enum BridgeTag {
    YES,
    VIADUCT,
    NO,
    AQUEDUCT,
    BOARDWALK,
    MOVABLE,
    SUSPENSION,
    CULVERT,
    ABANDONED,
    LOW_WATER_CROSSING,
    SIMPLE_BRUNNEL,
    COVERED;

    private static final EnumSet<BridgeTag> BRIDGE_WAYS;
    @TagKey
    public static final String KEY = "bridge";

    public static Optional<BridgeTag> get(Taggable taggable) {
        return Validators.from(BridgeTag.class, taggable);
    }

    public static boolean isBridge(Taggable taggable) {
        Optional<BridgeTag> bridge = BridgeTag.get(taggable);
        return bridge.isPresent() && BRIDGE_WAYS.contains((Object)bridge.get());
    }

    static {
        BRIDGE_WAYS = EnumSet.of(YES, new BridgeTag[]{VIADUCT, AQUEDUCT, BOARDWALK, MOVABLE, SUSPENSION, CULVERT, ABANDONED, LOW_WATER_CROSSING, SIMPLE_BRUNNEL, COVERED});
    }
}

