/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource.zip;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.resource.AbstractResource;
import org.openstreetmap.atlas.streaming.resource.Resource;

public class ZipResource {
    public static final String PREMATURE_READ_ERROR_MESSAGE = "Cannot go to the next ZipEntry before the previous one has been fully read.";
    private final Resource source;

    public ZipResource(Resource source) {
        this.source = source;
    }

    public Iterable<Resource> entries() {
        return () -> new ZipIterator(this.getSource());
    }

    public String getName() {
        return this.source.getName();
    }

    public String toString() {
        return this.getName();
    }

    protected Resource getSource() {
        return this.source;
    }

    public static class ZipIterator
    implements Iterator<Resource>,
    Closeable {
        private final Resource source;
        private final ZipInputStream input;
        private ZipEntry nextEntry = null;
        private boolean doneReading = true;

        public ZipIterator(Resource source) {
            this.source = source;
            this.input = new ZipInputStream(new BufferedInputStream(this.source.read()));
        }

        @Override
        public void close() {
            Streams.close(this.input);
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.nextEntry == null) {
                    this.nextEntry = this.input.getNextEntry();
                }
                if (this.nextEntry == null) {
                    this.close();
                }
                return this.nextEntry != null;
            }
            catch (IOException e) {
                throw new CoreException("Unable to go to next Zip Entry!", e);
            }
        }

        @Override
        public Resource next() {
            if (!this.doneReading) {
                throw new CoreException(ZipResource.PREMATURE_READ_ERROR_MESSAGE);
            }
            if (this.hasNext()) {
                this.doneReading = false;
                AbstractResource result = new AbstractResource(){
                    private final String name;
                    {
                        this.name = nextEntry.getName();
                    }

                    @Override
                    public String getName() {
                        return this.name;
                    }

                    @Override
                    protected InputStream onRead() {
                        return new InputStream(){

                            @Override
                            public void close() {
                                doneReading = true;
                            }

                            @Override
                            public int read() throws IOException {
                                return input.read();
                            }

                            @Override
                            public int read(byte[] buffer, int offset, int length) throws IOException {
                                return input.read(buffer, offset, length);
                            }
                        };
                    }
                };
                this.nextEntry = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

