/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource;

import com.google.common.base.Joiner;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openstreetmap.atlas.streaming.resource.Resource;

public enum FileSuffix {
    ATLAS(".atlas"),
    CHANGESET(".cs"),
    CSV(".csv"),
    GEO_JSON(".geojson"),
    GZIP(".gz"),
    EXTENDED(".ext"),
    JSON(".json"),
    NONE(""),
    OSMPBF(".osm.pbf"),
    OSM(".osm"),
    PBF(".pbf"),
    PROTOATLAS(".patlas"),
    TEMPORARY(".tmp"),
    TEXT(".txt"),
    ZIP(".zip"),
    WKT(".wkt"),
    WKB(".wkb");

    private final String suffix;

    public static FileSuffix getEnum(String value) {
        return FileSuffix.suffixFor(value).orElseThrow(() -> new IllegalArgumentException("No file suffix found for " + value));
    }

    public static Predicate<Path> pathFilter(FileSuffix ... listOfSuffixes) {
        String suffix = Joiner.on("").join((Object[])listOfSuffixes);
        return path -> path.getFileName().toString().toLowerCase().endsWith(suffix);
    }

    public static Predicate<Resource> resourceFilter(FileSuffix ... listOfSuffixes) {
        String suffix = Joiner.on("").join((Object[])listOfSuffixes);
        return resource -> resource.getName().endsWith(suffix);
    }

    public static Optional<FileSuffix> suffixFor(String value) {
        String compareMe = value.toLowerCase();
        return Stream.of(FileSuffix.values()).filter(suffix -> compareMe.endsWith(suffix.toString())).findFirst();
    }

    private FileSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean matches(Resource resource) {
        Optional<FileSuffix> foundSuffix = FileSuffix.suffixFor(resource.getName());
        return foundSuffix.isPresent() && foundSuffix.get() == this;
    }

    public String toString() {
        return this.suffix;
    }
}

