/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.compression.Decompressor;
import org.openstreetmap.atlas.streaming.resource.Resource;

public abstract class AbstractResource
implements Resource {
    private Decompressor decompressor = Decompressor.NONE;
    private String name = null;

    public Decompressor getDecompressor() {
        return this.decompressor;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return Resource.super.getName();
        }
        return this.name;
    }

    @Override
    public long length() {
        long l;
        BufferedInputStream input = new BufferedInputStream(this.read());
        try {
            long length = 0L;
            while (((InputStream)input).read() >= 0) {
                ++length;
            }
            l = length;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CoreException("Resource Length can't be obtained.", e);
            }
        }
        ((InputStream)input).close();
        return l;
    }

    @Override
    public final InputStream read() {
        if (this.decompressor == null) {
            return this.onRead();
        }
        return this.decompressor.decompress(this.onRead());
    }

    public void setDecompressor(Decompressor decompressor) {
        this.decompressor = decompressor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    protected abstract InputStream onRead();
}

