/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.readers.json.converters;

import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public class PointCoordinateConverter
implements Converter<Location, JsonArray> {
    private static final double DATE_LINE_LONGITUDE_WEST = -180.0;
    private static final double DATE_LINE_LONGITUDE_EAST = 180.0;

    @Override
    public JsonArray convert(Location location) {
        JsonArray coordinates = new JsonArray();
        coordinates.add(new JsonPrimitive(location.getLongitude().asDegrees()));
        coordinates.add(new JsonPrimitive(location.getLatitude().asDegrees()));
        return coordinates;
    }

    public Converter<JsonArray, Location> revert() {
        return jsonArray -> {
            double latitude = jsonArray.get(1).getAsDouble();
            double longitude = jsonArray.get(0).getAsDouble();
            if (longitude == 180.0) {
                longitude = -180.0;
            }
            return new Location(Latitude.degrees(latitude), Longitude.degrees(longitude));
        };
    }
}

