/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.readers;

import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.readers.CsvLine;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;

public class CsvSchema {
    private final List<StringConverter<? extends Object>> converters;

    public CsvSchema(Iterable<StringConverter<? extends Object>> converters) {
        this.converters = Iterables.asList(converters);
    }

    @SafeVarargs
    public CsvSchema(StringConverter<? extends Object> ... converters) {
        this.converters = Iterables.asList(Iterables.iterable(converters));
    }

    protected Object get(CsvLine line, int index) {
        this.verifyIndex(index);
        return this.converters.get(index).convert(line.getValue(index));
    }

    protected int size() {
        return this.converters.size();
    }

    private void verifyIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new CoreException("Index " + index + " out of CsvSchema bounds of 0 -> " + this.size());
        }
    }
}

