/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.readers;

import java.util.Iterator;
import org.openstreetmap.atlas.streaming.readers.CsvLine;
import org.openstreetmap.atlas.streaming.readers.CsvSchema;
import org.openstreetmap.atlas.streaming.resource.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReader
implements Iterator<CsvLine> {
    public static final Logger logger = LoggerFactory.getLogger(CsvReader.class);
    private final String comment;
    private final Iterator<String> lineIterator;
    private final CsvSchema schema;

    public CsvReader(CsvSchema schema, AbstractResource resource) {
        this.lineIterator = resource.lines().iterator();
        this.schema = schema;
        this.comment = "#";
    }

    public CsvReader(CsvSchema schema, AbstractResource resource, String comment) {
        this.lineIterator = resource.lines().iterator();
        this.schema = schema;
        this.comment = comment;
    }

    @Override
    public boolean hasNext() {
        return this.lineIterator.hasNext();
    }

    @Override
    public CsvLine next() {
        CsvLine result = null;
        do {
            String candidate;
            if ((candidate = this.lineIterator.next()) == null) {
                return null;
            }
            CsvLine csvLine = result = candidate.startsWith(this.comment) ? null : this.parse(candidate);
        } while (this.lineIterator.hasNext() && result == null);
        return result;
    }

    private CsvLine parse(String candidate) {
        try {
            return CsvLine.build(this.schema, candidate);
        }
        catch (Exception e) {
            logger.warn("Ignoring malformed line: -- {} --. Reason: {}", new Object[]{candidate, e.getMessage(), e});
            return null;
        }
    }
}

