/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;

public class SplittableInputStream
extends InputStream {
    private final MultiplexedSource multiSource;
    private final int myId;

    public SplittableInputStream(InputStream source) {
        this.multiSource = new MultiplexedSource(source);
        this.myId = this.multiSource.addSource(-1);
    }

    private SplittableInputStream(MultiplexedSource multiSource, int splitId) {
        this.multiSource = multiSource;
        this.myId = multiSource.addSource(splitId);
    }

    @Override
    public int read() throws IOException {
        return this.multiSource.read(this.myId);
    }

    public SplittableInputStream split() {
        return new SplittableInputStream(this.multiSource, this.myId);
    }

    public static class MultiplexedSource {
        public static final int MINIMUM_BUFFER = 512;
        public static final int MAXIMUM_BUFFER = 5120;
        private final InputStream source;
        private final List<Integer> readPositions = new ArrayList<Integer>();
        private int[] buffer = new int[512];
        private int writePosition = 0;

        public MultiplexedSource(InputStream source) {
            this.source = source;
        }

        public synchronized int read(int readerIdentifier) throws IOException {
            int position;
            int byteValue;
            if (this.readPositions.get(readerIdentifier) >= this.writePosition) {
                this.readJustBuffer();
                this.buffer[this.writePosition++] = this.source.read();
            }
            if ((byteValue = this.buffer[position = this.readPositions.get(readerIdentifier).intValue()]) != -1) {
                this.readPositions.set(readerIdentifier, position + 1);
            }
            return byteValue;
        }

        protected int addSource(int splitIdentifier) {
            this.readPositions.add(splitIdentifier == -1 ? 0 : this.readPositions.get(splitIdentifier));
            return this.readPositions.size() - 1;
        }

        private void readJustBuffer() {
            int from = Collections.min(this.readPositions);
            int whereTo = Collections.max(this.readPositions);
            int newLength = Math.max((whereTo - from) * 2, 512);
            if (newLength > 5120) {
                throw new CoreException("The SplittableInputStream buffer is blowing up. Make sure all the split streams (including the original one from which the splits originate!) are read at a similar pace.");
            }
            int[] newBuf = new int[newLength];
            System.arraycopy(this.buffer, from, newBuf, 0, whereTo - from);
            for (int i = 0; i < this.readPositions.size(); ++i) {
                this.readPositions.set(i, this.readPositions.get(i) - from);
            }
            this.writePosition -= from;
            this.buffer = newBuf;
        }
    }
}

