/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.proto.ProtoTag;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoTagListConverter
implements TwoWayConverter<List<ProtoTag>, Map<String, String>> {
    private static final Logger logger = LoggerFactory.getLogger(ProtoTagListConverter.class);

    @Override
    public List<ProtoTag> backwardConvert(Map<String, String> osmTagMap) {
        ArrayList<ProtoTag> protoTags = new ArrayList<ProtoTag>();
        for (Map.Entry<String, String> entry : osmTagMap.entrySet()) {
            String valueText;
            ProtoTag.Builder tagBuilder = ProtoTag.newBuilder();
            if (entry.getKey() == null) {
                logger.warn("Conversion from OSM tagmap found null key, skipping...");
                continue;
            }
            String keyText = entry.getKey();
            if (entry.getValue() == null) {
                logger.warn("Conversion from OSM tagmap found null value for key {}", (Object)keyText);
                valueText = "";
            } else {
                valueText = entry.getValue();
            }
            tagBuilder.setKey(keyText);
            tagBuilder.setValue(valueText);
            protoTags.add(tagBuilder.build());
        }
        return protoTags;
    }

    @Override
    public Map<String, String> convert(List<ProtoTag> protoTagList) {
        try {
            Map<String, String> result = Maps.hashMap(new String[0]);
            for (ProtoTag tag : protoTagList) {
                result.put(tag.getKey(), tag.getValue());
            }
            return result;
        }
        catch (Throwable error) {
            throw new CoreException("Unable to parse proto tags", error);
        }
    }
}

