/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.adapters;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.proto.ProtoAtlasMetaData;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.converters.ProtoTagListConverter;

public class ProtoAtlasMetaDataAdapter
implements ProtoAdapter {
    private static final ProtoTagListConverter PROTOTAG_LIST_CONVERTER = new ProtoTagListConverter();

    @Override
    public ProtoSerializable deserialize(byte[] byteArray) {
        boolean hasAllAtlasSizeFeatures;
        ProtoAtlasMetaData protoAtlasMetaData = null;
        try {
            protoAtlasMetaData = ProtoAtlasMetaData.parseFrom(byteArray);
        }
        catch (InvalidProtocolBufferException exception) {
            throw new CoreException("Error encountered while parsing protobuf bytestream", exception);
        }
        AtlasSize atlasSize = null;
        boolean bl = hasAllAtlasSizeFeatures = protoAtlasMetaData.hasEdgeNumber() && protoAtlasMetaData.hasNodeNumber() && protoAtlasMetaData.hasAreaNumber() && protoAtlasMetaData.hasLineNumber() && protoAtlasMetaData.hasPointNumber() && protoAtlasMetaData.hasRelationNumber();
        if (hasAllAtlasSizeFeatures) {
            atlasSize = new AtlasSize(protoAtlasMetaData.getEdgeNumber(), protoAtlasMetaData.getNodeNumber(), protoAtlasMetaData.getAreaNumber(), protoAtlasMetaData.getLineNumber(), protoAtlasMetaData.getPointNumber(), protoAtlasMetaData.getRelationNumber());
        }
        boolean original = protoAtlasMetaData.getOriginal();
        String codeVersion = null;
        if (protoAtlasMetaData.hasCodeVersion()) {
            codeVersion = protoAtlasMetaData.getCodeVersion();
        }
        String dataVersion = null;
        if (protoAtlasMetaData.hasDataVersion()) {
            dataVersion = protoAtlasMetaData.getDataVersion();
        }
        String country = null;
        if (protoAtlasMetaData.hasCountry()) {
            country = protoAtlasMetaData.getCountry();
        }
        String shardName = null;
        if (protoAtlasMetaData.hasShardName()) {
            shardName = protoAtlasMetaData.getShardName();
        }
        Map<String, String> tags = PROTOTAG_LIST_CONVERTER.convert(protoAtlasMetaData.getTagsList());
        AtlasMetaData atlasMetaData = new AtlasMetaData(atlasSize, original, codeVersion, dataVersion, country, shardName, tags);
        return atlasMetaData;
    }

    @Override
    public byte[] serialize(ProtoSerializable serializable) {
        if (!(serializable instanceof AtlasMetaData)) {
            throw new CoreException("Invalid ProtoSerializable type was provided to {}: cannot serialize {}", this.getClass().getName(), serializable.getClass().getName());
        }
        AtlasMetaData atlasMetaData = (AtlasMetaData)serializable;
        ProtoAtlasMetaData.Builder protoMetaDataBuilder = ProtoAtlasMetaData.newBuilder();
        if (atlasMetaData.getSize() != null) {
            protoMetaDataBuilder.setEdgeNumber(atlasMetaData.getSize().getEdgeNumber());
            protoMetaDataBuilder.setNodeNumber(atlasMetaData.getSize().getNodeNumber());
            protoMetaDataBuilder.setAreaNumber(atlasMetaData.getSize().getAreaNumber());
            protoMetaDataBuilder.setLineNumber(atlasMetaData.getSize().getLineNumber());
            protoMetaDataBuilder.setPointNumber(atlasMetaData.getSize().getPointNumber());
            protoMetaDataBuilder.setRelationNumber(atlasMetaData.getSize().getRelationNumber());
        }
        protoMetaDataBuilder.setOriginal(atlasMetaData.isOriginal());
        atlasMetaData.getCodeVersion().ifPresent(value -> protoMetaDataBuilder.setCodeVersion((String)value));
        atlasMetaData.getDataVersion().ifPresent(value -> protoMetaDataBuilder.setDataVersion((String)value));
        atlasMetaData.getCountry().ifPresent(value -> protoMetaDataBuilder.setCountry((String)value));
        atlasMetaData.getShardName().ifPresent(value -> protoMetaDataBuilder.setShardName((String)value));
        if (atlasMetaData.getTags() != null) {
            protoMetaDataBuilder.addAllTags(PROTOTAG_LIST_CONVERTER.backwardConvert(atlasMetaData.getTags()));
        }
        return protoMetaDataBuilder.build().toByteArray();
    }
}

