/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.locale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.locale.IsoCountry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsoCountryFuzzyMatcher {
    private static final Logger logger = LoggerFactory.getLogger(IsoCountryFuzzyMatcher.class);

    public static Optional<IsoCountry> forDisplayCountryClosestMatch(String displayCountry) {
        if (displayCountry != null) {
            if (IsoCountry.DISPLAY_COUNTRY_TO_ISO2.containsKey(displayCountry)) {
                return Optional.ofNullable(IsoCountry.ISO_COUNTRIES.get(IsoCountry.DISPLAY_COUNTRY_TO_ISO2.get(displayCountry)));
            }
            Optional<String> closestCountry = IsoCountryFuzzyMatcher.closestIsoCountry(displayCountry);
            if (closestCountry.isPresent()) {
                Optional<IsoCountry> closestMatch = Optional.ofNullable(IsoCountry.ISO_COUNTRIES.get(IsoCountry.DISPLAY_COUNTRY_TO_ISO2.get(closestCountry.get())));
                logger.info("Exact match for {} was not found, returning closest match {}", (Object)displayCountry, closestMatch);
                return closestMatch;
            }
        }
        return Optional.empty();
    }

    public static List<IsoCountry> forDisplayCountryTopMatches(int number, String displayCountry) {
        if (displayCountry != null) {
            ArrayList<IsoCountry> results = new ArrayList<IsoCountry>();
            if (IsoCountry.DISPLAY_COUNTRY_TO_ISO2.containsKey(displayCountry)) {
                results.add(IsoCountry.ISO_COUNTRIES.get(IsoCountry.DISPLAY_COUNTRY_TO_ISO2.get(displayCountry)));
            } else {
                List<String> closestCountries = IsoCountryFuzzyMatcher.closestIsoCountries(number, displayCountry);
                if (!closestCountries.isEmpty()) {
                    logger.info("Exact match for {} was not found, returning closest {} matches {}", new Object[]{displayCountry, number, closestCountries});
                    results.addAll(closestCountries.stream().map(countryString -> IsoCountry.ISO_COUNTRIES.get(IsoCountry.DISPLAY_COUNTRY_TO_ISO2.get(countryString))).collect(Collectors.toList()));
                }
            }
            return results;
        }
        return new ArrayList<IsoCountry>();
    }

    private static List<String> closestIsoCountries(int number, String displayCountry) {
        if (number <= 0 || number > IsoCountry.ALL_DISPLAY_COUNTRIES.size()) {
            throw new CoreException("number " + number + " out of range (0, " + IsoCountry.ALL_DISPLAY_COUNTRIES.size() + ")");
        }
        HashMap<String, Integer> countryRankings = new HashMap<String, Integer>();
        for (String countryName : IsoCountry.ALL_DISPLAY_COUNTRIES) {
            int distance = StringUtils.getLevenshteinDistance(displayCountry, countryName);
            countryRankings.put(countryName, distance);
        }
        ArrayList entries = new ArrayList(countryRankings.entrySet());
        Collections.sort(entries, (entry1, entry2) -> ((Integer)entry1.getValue()).compareTo((Integer)entry2.getValue()));
        return entries.subList(0, number).stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static Optional<String> closestIsoCountry(String displayCountry) {
        String closestCountry = null;
        int minimumDistance = Integer.MAX_VALUE;
        for (String countryName : IsoCountry.ALL_DISPLAY_COUNTRIES) {
            int distance = StringUtils.getLevenshteinDistance(displayCountry, countryName);
            if (distance >= minimumDistance) continue;
            closestCountry = countryName;
            minimumDistance = distance;
        }
        return Optional.ofNullable(closestCountry);
    }

    private IsoCountryFuzzyMatcher() {
    }
}

