/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding.converters;

import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.geography.sharding.GeoHashTile;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.Converter;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class StringToShardConverter
implements Converter<String, Shard> {
    private static final String COUNTRY_CODE_REGEX = "^[A-Z][A-Z0-9][A-Z0-9]$";
    private static final String SLIPPY_TILE_REGEX = "^[0-9]+\\-[0-9]+\\-[0-9]+$";
    private static final String GEOHASH_TILE_REGEX = "^(?:(?![ailo])[0-9a-z])+$";

    @Override
    public Shard convert(String shardString) {
        return this.convertWithMetadata(shardString).getFirst();
    }

    public Tuple<Shard, Optional<String>> convertWithMetadata(String shardString) {
        StringList shardSplit = StringList.split(shardString, "_", 2);
        try {
            return this.convertHelper(shardSplit);
        }
        catch (Exception exception) {
            throw new CoreException("Could not parse shard string: {}", shardString, exception);
        }
    }

    private Tuple<Shard, Optional<String>> convertHelper(StringList shardSplit) {
        if (shardSplit.size() == 1) {
            return this.shardFromSplitExcludingCountryShard(shardSplit);
        }
        if (shardSplit.size() > 1) {
            if (shardSplit.get(0).matches(COUNTRY_CODE_REGEX)) {
                StringList newListWithoutLeadingCountryCode = StringList.split(shardSplit.get(1), "_", 2);
                Tuple<Shard, Optional<String>> conversionResult = this.convertHelper(newListWithoutLeadingCountryCode);
                return new Tuple<Shard, Optional<String>>(new CountryShard(shardSplit.get(0), conversionResult.getFirst()), conversionResult.getSecond());
            }
            return this.shardFromSplitExcludingCountryShard(shardSplit);
        }
        throw new CoreException("Split list {} had invalid size {}, must be at least 1", shardSplit, shardSplit.size());
    }

    private Tuple<Shard, Optional<String>> shardFromSplitExcludingCountryShard(StringList shardSplit) {
        Shard shard;
        if (shardSplit.size() < 1) {
            throw new CoreException("Split list {} had invalid size {}, must be at least 1", shardSplit, shardSplit.size());
        }
        String shardString = shardSplit.get(0);
        if (shardString.matches(SLIPPY_TILE_REGEX)) {
            shard = SlippyTile.forName(shardString);
        } else if (shardString.matches(GEOHASH_TILE_REGEX)) {
            shard = GeoHashTile.forName(shardString);
        } else {
            throw new CoreException("Unrecognized shard component: {}", shardString);
        }
        if (shardSplit.size() > 1) {
            return new Tuple<Shard, Optional<String>>(shard, Optional.of(shardSplit.get(1)));
        }
        return new Tuple<Shard, Optional<String>>(shard, Optional.empty());
    }
}

